package com.biz.crm.tpm.business.budget.discount.rate.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.SurplusFeePoolBalance;
import com.biz.crm.tpm.business.budget.discount.rate.local.mapper.SurplusFeePoolBalanceMapper;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/3/2 10:00
 * @description: 剩余费用池余额(SurplusFeePoolBalance)表数据库访问层
 */
@Component
public class SurplusFeePoolBalanceRepository extends ServiceImpl<SurplusFeePoolBalanceMapper, SurplusFeePoolBalance> {

    @Autowired(required = false)
    private SurplusFeePoolBalanceMapper surplusFeePoolBalanceMapper;

    /**
     * 重构修改方法
     *
     * @param entity     实体类
     * @param tenantCode 租户编码
     */
    public void updateByIdAndTenantCode(SurplusFeePoolBalance entity, String tenantCode) {
        LambdaUpdateWrapper<SurplusFeePoolBalance> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(SurplusFeePoolBalance::getTenantCode, tenantCode);
        lambdaUpdateWrapper.eq(SurplusFeePoolBalance::getId, entity.getId());
        this.baseMapper.update(entity, lambdaUpdateWrapper);
    }


    /**
     * 重构批量修改方法
     *
     * @param entitys    实体类集合
     * @param tenantCode 租户编码
     */
    public void updateBatchByIdAndTenantCode(Collection<SurplusFeePoolBalance> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty(tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank(item.getId())) {
                LambdaUpdateWrapper<SurplusFeePoolBalance> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(SurplusFeePoolBalance::getTenantCode, tenantCode);
                lambdaUpdateWrapper.eq(SurplusFeePoolBalance::getId, item.getId());
                this.baseMapper.update(item, lambdaUpdateWrapper);
            }
        });
    }

    /**
     * 获取剩余费用池余额通过onlyKeys
     *
     * @param keyList    onlyKey列表
     * @param tenantCode 租户
     * @return 列表数据
     */
    public List<SurplusFeePoolBalanceVo> getPoolBalanceByOnlyKeys(List<List<String>> keyList, String tenantCode) {
        if (CollectionUtils.isEmpty(keyList) || StringUtil.isBlank(tenantCode)) {
            return Lists.newArrayList();
        }
        return this.surplusFeePoolBalanceMapper.getPoolBalanceByOnlyKeys(keyList, tenantCode);
    }

    /**
     * 获取剩余费用池余额
     *
     * @param dto 参数
     * @return Map<String, BigDecimal>
     */
    public List<SurplusFeePoolBalanceVo> getAmountByDate(SurplusFeePoolBalanceDto dto, String tenantCode) {
        if (StringUtil.isBlank(dto.getYearMonthStr()) || StringUtil.isBlank(dto.getBusinessFormatCode()) || StringUtil.isBlank(dto.getBusinessUnitCode()) || StringUtil.isBlank(tenantCode)) {
            return Lists.newArrayList();
        }
        return this.surplusFeePoolBalanceMapper.getAmountByDate(dto, tenantCode);
    }

    public List<SurplusFeePoolBalanceVo> findListForFR(List<SurplusFeePoolBalanceDto> balanceDtos, String code) {
        return this.surplusFeePoolBalanceMapper.findListForFR(balanceDtos,code,TenantUtils.getTenantCode());
    }
}
