package com.biz.crm.tpm.business.budget.discount.rate.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.DiscountAccountFeeGroupVo;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.SurplusFeePoolSoldBalance;
import com.biz.crm.tpm.business.budget.discount.rate.local.mapper.SurplusFeePoolSoldBalanceMapper;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolSoldBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolSoldBalanceVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class SurplusFeePoolSoldBalanceRepository extends ServiceImpl<SurplusFeePoolSoldBalanceMapper, SurplusFeePoolSoldBalance> {

    /**
     * 根据唯一条件查询数据
     * @param onlyKey
     * @return
     */
    public SurplusFeePoolSoldBalance findSurplusFeePoolSoldBalance(String onlyKey) {
        return this.lambdaQuery()
                .eq(SurplusFeePoolSoldBalance::getOnlyKey, onlyKey)
                .eq(SurplusFeePoolSoldBalance::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    /**
     * 分页获取上月余留数据
     * @param pageable
     * @param dto
     * @return
     */
    public Page<SurplusFeePoolSoldBalance> continueLastMonthSurplusFeePoolSoldeBalance(Pageable pageable, SurplusFeePoolSoldBalanceDto dto) {
        Page<SurplusFeePoolSoldBalance> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<SurplusFeePoolSoldBalance> pageList = this.baseMapper.continueLastMonthSurplusFeePoolSoldeBalance(page, dto);
        return pageList;
    }

    /**
     * 分页获取费用池余额数据
     * @param pageable
     * @param dto
     * @return
     */
    public Page<SurplusFeePoolSoldBalanceVo> findByConditions(Pageable pageable, SurplusFeePoolSoldBalanceDto dto) {
        Page<SurplusFeePoolSoldBalanceVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<SurplusFeePoolSoldBalanceVo> pageList = this.baseMapper.findByConditions(page, dto);
        return pageList;
    }

}
