package com.biz.crm.tpm.business.budget.discount.rate.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDimensionDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDimensionPageDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigDimensionVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/1/6 10:09
 * @description: 折扣率配置维度管理(DiscountRateConfigDimension)表服务接口
 */
public interface DiscountRateConfigDimensionService {

    /**
     * 批量保存维度信息
     *
     * @param dimensionList 维度数据列表
     * @param configCode    配置编码
     * @param tenantCode    租户编码
     */
    void saveBatchDimension(List<DiscountRateConfigDimensionDto> dimensionList, String configCode, String tenantCode);

    /**
     * 批量修改维度信息
     *
     * @param dimensionList 维度数据列表
     * @param configCode    配置编码
     * @param tenantCode    租户编码
     */
    void editBatchDimension(List<DiscountRateConfigDimensionDto> dimensionList, String configCode, String tenantCode);

    /**
     * 获取维度信息列表
     *
     * @param pageable 分页参数
     * @param pageDto  筛选参数
     * @return List<DiscountRateConfigDimensionVo>
     */
    Page<DiscountRateConfigDimensionVo> findDimension(Pageable pageable, DiscountRateConfigDimensionPageDto pageDto);
}
