package com.biz.crm.tpm.business.budget.discount.rate.local.service;

import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigFormulaVariableVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;

import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/1/6 10:08
 * @description: 折扣率配置管理(DiscountRateConfig)表服务接口
 */
public interface DiscountRateConfigService {

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    DiscountRateConfigVo findById(String id);

    /**
     * 新增数据
     *
     * @param configDto dto对象
     */
    void create(DiscountRateConfigDto configDto);

    /**
     * 修改数据
     *
     * @param configDto dto对象
     */
    void update(DiscountRateConfigDto configDto);

    /**
     * 删除数据
     *
     * @param ids 主键结合
     */
    void delete(List<String> ids);

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 获取折扣率配置公式变量
     *
     * @param businessUnitCode 业务单元
     * @return 列表数据
     */
    List<DiscountRateConfigFormulaVariableVo> getFormulaVariable(String businessUnitCode);

    /**
     * 获取折扣率配置通过onlyKeys
     *
     * @param onlyKeys onlyKey列表
     * @return 列表数据
     */
    Map<String, DiscountRateConfig> getConfigByOnlyKeys(List<String> onlyKeys);
}
