package com.biz.crm.tpm.business.budget.discount.rate.local.service;

import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateProcessDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateRecalDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;

import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/1/6 10:09
 * @description: 折扣率管理(DiscountRate)表服务接口
 */
public interface DiscountRateService {

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    DiscountRateVo findById(String id);

//    /**
//     * 新增数据
//     *
//     * @param configDto dto对象
//     * @return 新增结果
//     */
//    @ApiOperation(value = "新增数据")
//    @PostMapping
//    public Result<?> create(@ApiParam(name = "configDto", value = "折扣率配置主表Dto") @RequestBody DiscountRateConfigDto configDto) {
//        try {
//            this.discountRateConfigService.create(configDto);
//            return Result.ok();
//        } catch (RuntimeException e) {
//            log.error(e.getMessage(), e);
//            return Result.error(e.getMessage());
//        }
//    }

    /**
     * 修改数据
     *
     * @param rateDto dto对象
     */
    void update(DiscountRateDto rateDto);

    /**
     * 删除数据
     *
     * @param ids 主键结合
     */
    void delete(List<String> ids);

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 大批量保存
     *
     * @param importList 导入数据列表
     */
    void bulkImportSave(List<DiscountRateDto> importList);

    /**
     * 提交工作流
     *
     * @param processDto 参数
     */
    void submitApproval(DiscountRateProcessDto processDto);

    /**
     * 流程审批通过
     *
     * @param dto 流程参数
     */
    void processPass(ProcessStatusDto dto);

    /**
     * 审批驳回|流程追回
     *
     * @param dto 流程参数
     */
    void processRejectAndRecover(ProcessStatusDto dto);

    /**
     * 更新计算
     *
     * @param recalDto 参数
     */
    void recal(DiscountRateRecalDto recalDto);

    /**
     * 通过折扣率配置自动生成折扣率
     *
     *@param yearMonth 年月
     */
    void verticalDiscountRateCal(String yearMonth);

    /**
     * 根据onlykeys获取id
     *
     * @param keys onlyKey列表
     * @return Map<String,String>
     */
    Map<String,String> getIdByKeys(List<String> keys);
}
