package com.biz.crm.tpm.business.budget.discount.rate.local.service;


import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2022/12/26 14:23
 * @description: 公式服务
 */
public interface DiscountRateVariableService {

    /**
     * 单个公式计算
     *
     * @param dto 计算所需参数
     * @return 计算结果
     */
    BigDecimal singleCalculateExpression(CalculateDto dto);

    /**
     * 单个公式计算,返回批量结果
     *
     * @param dto 计算所需参数
     * @return 计算结果
     */
    Map<String,BigDecimal> singleCalculateExpressionBatch(CalculateDto dto);
}
