package com.biz.crm.tpm.business.budget.discount.rate.local.service;

import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/3/2 10:10
 * @description: 剩余费用池余额(SurplusFeePoolBalance)表服务接口
 */
public interface SurplusFeePoolBalanceService {


    /**
     * 获取剩余费用池余额通过onlyKeys
     *
     * @param onlyKeys onlyKey列表
     * @return 列表数据
     */
    Map<String, SurplusFeePoolBalanceVo> getPoolBalanceByOnlyKeys(List<String> onlyKeys);

    /**
     * 获取剩余费用池余额
     *
     * @param dto 参数
     * @return Map<String, BigDecimal>
     */
    Map<String, BigDecimal> getAmountByDate(SurplusFeePoolBalanceDto dto);

    /**
     * 计算剩余费用池余额
     *
     * @param yearMonth 年月
     */
    void verticalSurplusFeePoolBalanceCal(String yearMonth);

    /**
     * 获取105的折扣金额
     *
     * @param disMap 折扣金额map
     * @param businessUnitCode 业务单元
     * @param businessFormatCode 业态
     * @param yearMonth 年月字符串（yyyy-MM）
     */
    void get105Discount(Map<String, BigDecimal> disMap, String businessUnitCode,String businessFormatCode, String yearMonth);
}
