package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRate;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateAsyncService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateLogService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.constant.DiscountRateConstant;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateLogEventDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import springfox.documentation.spring.web.json.Json;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/1/9 16:22
 * @description: 折扣率异步服务实现类
 */
@Service("DiscountRateAsyncService")
@Slf4j
public class DiscountRateAsyncServiceImpl implements DiscountRateAsyncService {

    @Autowired(required = false)
    private DiscountRateRepository discountRateRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DiscountRateLogService discountRateLogService;
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;


    /**
     * 折扣率批量新增和编辑
     *
     * @param list 数据列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchAddEdit(List<DiscountRateDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<List<DiscountRateDto>> rateList = Lists.partition(list, 500);
        //500一组，分组进行新增和编辑
        for (List<DiscountRateDto> rates : rateList) {
            //查询重复数据
            List<DiscountRate> oldList = discountRateRepository.lambdaQuery()
                    .eq(DiscountRate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(DiscountRate::getTenantCode, TenantUtils.getTenantCode())
                    .in(DiscountRate::getOnlyKey, rates.stream().map(DiscountRateDto::getOnlyKey).collect(Collectors.toList()))
                    .list();
            Map<String, DiscountRate> oldMap = new HashMap<>();
            List<DiscountRateDto> newList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(oldList)) {
                oldMap = oldList.stream().collect(Collectors.toMap(DiscountRate::getOnlyKey, Function.identity()));
                //编辑
                List<DiscountRateLogEventDto> editLogs = new ArrayList<>();
                for (DiscountRateDto dto : rates) {
                    if (!oldMap.containsKey(dto.getOnlyKey())) {
                        newList.add(dto);
                        continue;
                    }
                    DiscountRate old = oldMap.get(dto.getOnlyKey());
                    //组装编辑日志dto
                    DiscountRateLogEventDto eventDto = new DiscountRateLogEventDto();
                    DiscountRateVo rateVo = this.nebulaToolkitService.copyObjectByWhiteList(old, DiscountRateVo.class, HashSet.class, ArrayList.class);
                    eventDto.setOriginal(rateVo);
                    old.setPlanRate(dto.getPlanRate());
                    old.setPlanRateStr(dto.getPlanRateStr());
                    old.setConfigCode(dto.getConfigCode());
                    old.setApproveTag(dto.getApproveTag());
                    old.setProcessStatus(dto.getProcessStatus());
                    DiscountRateDto dtoVo = this.nebulaToolkitService.copyObjectByWhiteList(old, DiscountRateDto.class, HashSet.class, ArrayList.class);
                    eventDto.setNewest(dtoVo);
                    editLogs.add(eventDto);
                }
                this.discountRateRepository.updateBatchByIdAndTenantCode(oldMap.values(), TenantUtils.getTenantCode());
                this.discountRateLogService.updateLogAsync(editLogs);
            } else {
                newList = rates;
            }

            //新增
            if (!CollectionUtils.isEmpty(newList)) {
//                String ruleCode = StringUtils.join(DiscountRateConstant.DISCOUNT_RATE_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
                List<String> codes = this.generateCodeService.generateCode(DiscountRateConstant.DISCOUNT_RATE_PREFIX, newList.size(), 5, 2, TimeUnit.DAYS);
                for (int i = 0; i < newList.size(); i++) {
                    DiscountRateDto o = newList.get(i);
                    o.setDiscountRateCode(codes.get(i));
                }
                Collection<DiscountRate> addList = this.nebulaToolkitService.copyCollectionByBlankList(newList, DiscountRateDto.class, DiscountRate.class, HashSet.class, ArrayList.class);
                this.discountRateRepository.saveBatch(addList);
                this.discountRateLogService.addLogAsync(newList);
            }
        }
    }
}
