package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateConfigRepository;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateConfigSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author: chenlong
 * @date: 2023/1/6 11:26
 * @description: 折扣率配置管理(DiscountRateConfig)表sdk服务实现类
 */
@Service("discountRateConfigSdkService")
public class DiscountRateConfigSdkServiceImpl implements DiscountRateConfigSdkService {

    @Autowired(required = false)
    private DiscountRateConfigRepository discountRateConfigRepository;

    /**
     * 分页查询所有数据
     *
     * @param pageable  分页对象
     * @param configDto 查询dto
     * @return 所有数据
     */
    @Override
    public Page<DiscountRateConfigVo> findByConditions(Pageable pageable, DiscountRateConfigDto configDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(configDto)) {
            configDto = new DiscountRateConfigDto();
        }
        configDto.setTenantCode(TenantUtils.getTenantCode());
        return this.discountRateConfigRepository.findByConditions(pageable, configDto);
    }
}
