package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateLogService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateLogEventDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.event.log.DiscountRateEventListener;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/2/9 21:21
 * @description:
 */
@Service("DiscountRateLogService")
public class DiscountRateLogServiceImpl implements DiscountRateLogService {

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Async("logThread")
    @Override
    public void addLogAsync(List<DiscountRateDto> addList) {
        SerializableBiConsumer<DiscountRateEventListener, DiscountRateLogEventDto> onCreate =
                DiscountRateEventListener::onCreate;
        for (DiscountRateDto in : addList) {
            //新增业务日志
            DiscountRateLogEventDto logEventDto = new DiscountRateLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(in);
            this.nebulaNetEventClient.publish(logEventDto, DiscountRateEventListener.class, onCreate);
        }
    }

    @Async("logThread")
    @Override
    public void updateLogAsync(List<DiscountRateLogEventDto> editLogs) {
        SerializableBiConsumer<DiscountRateEventListener, DiscountRateLogEventDto> onUpdate =
                DiscountRateEventListener::onUpdate;
        for (DiscountRateLogEventDto log : editLogs) {
            this.nebulaNetEventClient.publish(log, DiscountRateEventListener.class, onUpdate);
        }
    }
}
