package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateVariableService;
import com.biz.crm.tpm.business.budget.discount.rate.local.variable.utils.DiscountRateVariableUtil;
import com.biz.crm.tpm.business.budget.discount.rate.local.variable.utils.MathUtil;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/12/26 14:26
 * @description: 公式服务实现类
 */
@Slf4j
@Service("DiscountRateVariableService")
public class DiscountRateVariableServiceImpl implements DiscountRateVariableService {

    @Autowired(required = false)
    private List<FormulaVariableRegister> formulaVariableRegisterList;
    @Autowired(required = false)
    private DiscountRateVariableUtil discountRateVariableUtil;


    @Override
    public BigDecimal singleCalculateExpression(CalculateDto dto) {
        Validate.notNull(dto, "计算公式时，参数不能为空");
        //匹配的公式
        Validate.notNull(dto.getFormula(), "未查找到公式");
        Set<String> formulas = MathUtil.getFormulaReplace(dto.getFormula());
        //获取变量值
        Map<String, BigDecimal> variableValueMap = new HashMap<>();
        formulas.forEach(variableName -> {
            List<FormulaVariableRegister> list = formulaVariableRegisterList.stream().filter(register -> variableName.startsWith(register.getVariableCode())).collect(Collectors.toList());
            Validate.noNullElements(list, "变量注册器不存在");
            FormulaVariableRegister formulaVariableRegister = list.get(0);
            BigDecimal b = formulaVariableRegister.calculateVariable(dto);
            if (Objects.isNull(b)) {
                b = BigDecimal.ZERO;
            }
            variableValueMap.put(variableName, b);
        });
        //计算表达式
        //替换
        String expressValue = discountRateVariableUtil.replaceExpression(dto.getFormula(), formulas, variableValueMap);
        //执行计算
        return MathUtil.computeFormula(expressValue);
    }

    @Override
    public Map<String, BigDecimal> singleCalculateExpressionBatch(CalculateDto dto) {
        Validate.notNull(dto, "计算公式时，参数不能为空");
        //匹配的公式
        Validate.notNull(dto.getFormula(), "未查找到公式");
        Set<String> formulas = MathUtil.getFormulaReplace(dto.getFormula());
        //获取变量值(变量->(维度key->值))
        Map<String, Map<String, BigDecimal>> variableValueMap = new HashMap<>();
        formulas.forEach(variableName -> {
            List<FormulaVariableRegister> list = formulaVariableRegisterList.stream().filter(register -> variableName.equals(register.getVariableCode())).collect(Collectors.toList());
            Validate.noNullElements(list, "变量注册器不存在");
            FormulaVariableRegister formulaVariableRegister = list.get(0);
            Map<String, BigDecimal> b = formulaVariableRegister.calculateVariableBatch(dto);
            if (Objects.isNull(b)) {
                b = new HashMap<>();
            }
            variableValueMap.put(variableName, b);
        });
        //将公式返回的map转换为 (维度key->(变量->值))
        Map<String, Map<String, BigDecimal>> variableValueMap2 = new HashMap<>();
        for (String s : variableValueMap.keySet()) {
            Map<String, BigDecimal> varMap = variableValueMap.get(s);
            for (String s1 : varMap.keySet()) {
                if (variableValueMap2.containsKey(s1)) {
                    variableValueMap2.get(s1).put(s, varMap.get(s1));
                } else {
                    Map<String, BigDecimal> newMap = new HashMap<>();
                    newMap.put(s, varMap.get(s1));
                    variableValueMap2.put(s1, newMap);
                }
            }
        }
        //在计算表达式
        Map<String, BigDecimal> map = new HashMap<>();
        for (String key : variableValueMap2.keySet()) {
            //替换
            String expressValue = discountRateVariableUtil.replaceExpression(dto.getFormula(), formulas, variableValueMap2.get(key));
            //执行计算
            //计算报错则为0
            BigDecimal b = BigDecimal.ZERO;
            try {
                b = MathUtil.computeFormula(expressValue);
            }catch (Exception e){
                log.error("折扣率定时任务计算表达式报错：{},key = {}",e.getMessage(),key);
            }
            map.put(key, b);
        }
        return map;
    }
}
