package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.biz.crm.tpm.business.budget.discount.rate.local.repository.SurplusFeePoolBalanceRepository;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.SurplusFeePoolBalanceSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author h.b
 * @data 2023-05-05
 */
@Service
public class SurplusFeePoolBalanceSdkServiceImpl implements SurplusFeePoolBalanceSdkService {

    @Autowired(required = false)
    private SurplusFeePoolBalanceRepository surplusFeePoolBalanceRepository;


    @Override
    public List<SurplusFeePoolBalanceVo> getSurplusFeePoolBalanceByParams(SurplusFeePoolBalanceDto surplusFeePoolBalance) {

        String tenantCode = TenantUtils.getTenantCode();

        return this.surplusFeePoolBalanceRepository.getAmountByDate(surplusFeePoolBalance, tenantCode);
    }

    /**
     * 费用池余额表报表年月的期初余额
     * @param balanceDtos
     * @param code
     * @return
     */
    @Override
    public List<SurplusFeePoolBalanceVo> findListForFR(List<SurplusFeePoolBalanceDto> balanceDtos, String code) {
        if(CollectionUtils.isEmpty(balanceDtos)) return Lists.newArrayListWithCapacity(0);
        return this.surplusFeePoolBalanceRepository.findListForFR(balanceDtos,code);
    }
}
