package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.match.sdk.dto.SurplusFeePoolBalanceAuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditSapVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.SurplusFeePoolBalanceAuditMatchVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.SurplusFeePoolBalance;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateConfigRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.SurplusFeePoolBalanceRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolBalanceService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.constant.DiscountRateConstant;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateConfigSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.SurplusFeePoolBalanceAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.enums.AssociationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/3/2 10:11
 * @description: 剩余费用池余额(SurplusFeePoolBalance)表服务接口实现类
 */
@Slf4j
@Service("surplusFeePoolBalanceService")
public class SurplusFeePoolBalanceServiceImpl implements SurplusFeePoolBalanceService {

    @Autowired(required = false)
    private SurplusFeePoolBalanceRepository surplusFeePoolBalanceRepository;
    @Autowired(required = false)
    private DiscountRateConfigSdkService discountRateConfigSdkService;
    @Autowired(required = false)
    private DiscountRateConfigRepository discountRateConfigRepository;
    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required = false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required = false)
    private TerminalVoService terminalVoService;
    @Autowired(required = false)
    private AuditSapVoService auditSapVoService;
    @Autowired(required = false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private LoginUserService loginUserService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    /**
     * 获取剩余费用池余额通过onlyKeys
     *
     * @param onlyKeys onlyKey列表
     * @return 列表数据
     */
    @Override
    public Map<String, SurplusFeePoolBalanceVo> getPoolBalanceByOnlyKeys(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return Maps.newHashMap();
        }
        List<List<String>> keyList = Lists.partition(onlyKeys, 500);
        List<SurplusFeePoolBalanceVo> list = this.surplusFeePoolBalanceRepository.getPoolBalanceByOnlyKeys(keyList, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(SurplusFeePoolBalanceVo::getOnlyKey, Function.identity(), (oldValue, newValue) -> newValue));
    }

    /**
     * 获取剩余费用池余额
     *
     * @param dto 参数
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> getAmountByDate(SurplusFeePoolBalanceDto dto) {
        if (StringUtil.isBlank(dto.getYearMonthStr()) || StringUtil.isBlank(dto.getBusinessFormatCode()) || StringUtil.isBlank(dto.getBusinessUnitCode())) {
            return Maps.newHashMap();
        }
        List<SurplusFeePoolBalanceVo> list = this.surplusFeePoolBalanceRepository.getAmountByDate(dto, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(SurplusFeePoolBalanceVo::getOnlyKey, SurplusFeePoolBalanceVo::getBalance, (oldValue, newValue) -> newValue));
    }

    /**
     * 计算剩余费用池余额
     *
     * @param yearMonth 年月
     */
    @Override
    public void verticalSurplusFeePoolBalanceCal(String yearMonth) {
        if (StringUtil.isBlank(yearMonth)) {
            return;
        }
        //设置基础信息
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        //先查询折扣率配置
        DiscountRateConfigDto configDto = new DiscountRateConfigDto();
        configDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        //这里目前只生成垂直-零售商+区域的期初
//        configDto.setDimensionType(DiscountRateDimensionEnum.RETAILER_REGION_BRAND.getCode());
        configDto.setDimensionType(DiscountRateDimensionEnum.RETAILER_REGION.getCode());
        //查询折扣率配置条数
        Integer count = discountRateConfigRepository.lambdaQuery()
                .eq(DiscountRateConfig::getTenantCode, TenantUtils.getTenantCode())
                .eq(DiscountRateConfig::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(DiscountRateConfig::getDimensionType, configDto.getDimensionType())
                .eq(DiscountRateConfig::getBusinessUnitCode, configDto.getBusinessUnitCode())
                .count();
        if (count == 0) {
            return;
        }
        //查询零售商，区域，品牌的名称
        Map<String, String> sysMap = customerRetailerVoService.getAllRetailerCode();
        Map<String, String> regionMap = this.dictToolkitService.findMapByDictTypeCode(DiscountRateConstant.MDM_CUSTOMIZE_ORG);
//        Map<String, String> brandMap = productBrandService.getAllBrandCode();

        //上月时间
        Date date = DateUtil.strToDate(yearMonth, DateUtil.date_yyyy_MM);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, -1);
        String lastYearMonthStr = DateUtil.dateToStr(calendar.getTime(), DateUtil.date_yyyy_MM);

        int i = 1;
        while (true) {
            Page<DiscountRateConfigVo> page = discountRateConfigSdkService.findByConditions(PageRequest.of(i, 50), configDto);
            if (CollectionUtils.isEmpty(page.getRecords())) {
                return;
            }
            //循环折扣率配置，根据公式统计数据
            for (DiscountRateConfigVo record : page.getRecords()) {
                //获取上月期初

                SurplusFeePoolBalanceDto balanceDto = new SurplusFeePoolBalanceDto();
                balanceDto.setBusinessFormatCode(record.getBusinessFormatCode());
                balanceDto.setBusinessUnitCode(record.getBusinessUnitCode());
                balanceDto.setYearMonthStr(lastYearMonthStr);
                Map<String, BigDecimal> periodMap = this.getAmountByDate(balanceDto);
                //获取上账金额
                ActivityDetailPlanItemStatisticsDto dto = new ActivityDetailPlanItemStatisticsDto();
                dto.setBusinessFormatCode(record.getBusinessFormatCode());
                dto.setBusinessUnitCode(record.getBusinessUnitCode());
                dto.setFeeYearMonth(DateUtil.strToDate(lastYearMonthStr, DateUtil.date_yyyy_MM));
                dto.setTenantCode(TenantUtils.getTenantCode());
                dto.setEndCaseForm(EndCaseFormEnum.DISCOUNT.getCode());
                Map<String, BigDecimal> accountMap = activityDetailPlanItemSdkService.statisDiscountAccountFee(dto);
                //获取考核扣款
                SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto = new SurplusFeePoolBalanceAssessedAmountStatisticsDto();
                assessDto.setBusinessFormatCode(record.getBusinessFormatCode());
                assessDto.setBusinessUnitCode(record.getBusinessUnitCode());
                assessDto.setFeeYearMonth(DateUtil.strToDate(lastYearMonthStr, DateUtil.date_yyyy_MM));
                assessDto.setRelationType(AssociationTypeEnum.EXPENSE_POOL.getCode());
                Map<String, BigDecimal> assessMap = tpmExamineCircularService.statisAssessDeduction(assessDto);
                //获取105数据折扣金额
                Map<String, BigDecimal> disMap = new HashMap<>();
                this.get105Discount(disMap, record.getBusinessUnitCode(), record.getBusinessFormatCode(), lastYearMonthStr);

                //开始计算期初
                Set<String> splicingCodeSet = new HashSet<>();
                if(!periodMap.isEmpty()){
                    log.error("periodMap的key[{}]",periodMap.keySet());
                    splicingCodeSet.addAll(periodMap.keySet());
                }
                if (!accountMap.isEmpty()) {
                    log.error("accountMap的key[{}]",accountMap.keySet());
                    splicingCodeSet.addAll(accountMap.keySet());
                }
                if (!assessMap.isEmpty()) {
                    log.error("assessMap的key[{}]",assessMap.keySet());
                    splicingCodeSet.addAll(assessMap.keySet());
                }
                if (!disMap.isEmpty()) {
                    log.error("disMap的key[{}]",disMap.keySet());
                    splicingCodeSet.addAll(disMap.keySet());
                }
                List<SurplusFeePoolBalance> balanceList = new ArrayList<>();
                for (String s : splicingCodeSet) {
                    BigDecimal b = BigDecimal.ZERO;
                    b = b.add(periodMap.getOrDefault(s, BigDecimal.ZERO));
                    b = b.add(accountMap.getOrDefault(s, BigDecimal.ZERO));
                    b = b.add(assessMap.getOrDefault(s, BigDecimal.ZERO));
                    b = b.subtract(disMap.getOrDefault(s, BigDecimal.ZERO));

                    String[] arr = s.split("-");
                    if (arr.length < 2) {
                        continue;
                    }
                    SurplusFeePoolBalance balance = new SurplusFeePoolBalance();
                    balance.setBalance(b);
//                    balance.setBrandCode(arr[2]);
//                    balance.setBrandName(brandMap.getOrDefault(arr[2], null));
                    balance.setCustomerRetailerCode(arr[0]);
                    balance.setCustomerRetailerName(sysMap.getOrDefault(arr[0], null));
                    balance.setRegionCode(arr[1]);
                    balance.setRegionName(regionMap.getOrDefault(arr[1], null));
                    balance.setBusinessFormatCode(record.getBusinessFormatCode());
                    balance.setBusinessUnitCode(record.getBusinessUnitCode());
                    balance.setYearMonthStr(yearMonth);
                    balance.setOnlyKey(balance.getBusinessFormatCode() + "-" + balance.getBusinessUnitCode() + "-"
                            + s + "-" + yearMonth.replaceAll("-", ""));
                    balance.setTenantCode(TenantUtils.getTenantCode());
                    balanceList.add(balance);
                }

                if (!CollectionUtils.isEmpty(balanceList)) {
                    Set<String> onlyKeys = balanceList.stream().map(SurplusFeePoolBalance::getOnlyKey).collect(Collectors.toSet());
                    //查询历史数据
                    List<SurplusFeePoolBalance> oldBaList = this.surplusFeePoolBalanceRepository.lambdaQuery()
                            .in(SurplusFeePoolBalance::getOnlyKey, onlyKeys)
                            .eq(SurplusFeePoolBalance::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                            .eq(SurplusFeePoolBalance::getTenantCode, TenantUtils.getTenantCode())
                            .list();
                    if (!CollectionUtils.isEmpty(oldBaList)) {
                        Map<String, String> oldBaMap = oldBaList.stream().collect(
                                Collectors.toMap(SurplusFeePoolBalance::getOnlyKey, SurplusFeePoolBalance::getId));
                        for (SurplusFeePoolBalance balance : balanceList) {
                            if (oldBaMap.containsKey(balance.getOnlyKey())) {
                                balance.setId(oldBaMap.getOrDefault(balance.getOnlyKey(), null));
                            }
                        }
                    }
                }

                this.surplusFeePoolBalanceRepository.saveOrUpdateBatch(balanceList);
            }
            i++;
        }
    }

    /**
     * 获取105的折扣金额
     *
     * @param disMap             折扣金额map
     * @param businessUnitCode   业务单元
     * @param businessFormatCode 业态
     * @param yearMonth          年月字符串（yyyy-MM）
     */
    @Override
    public void get105Discount(Map<String, BigDecimal> disMap, String businessUnitCode, String businessFormatCode, String yearMonth) {
        //先分页获取门店
        TerminalPaginationDto terDto = new TerminalPaginationDto();
        terDto.setTenantCode(TenantUtils.getTenantCode());
        terDto.setBusinessUnitCode(businessUnitCode);
        terDto.setBusinessFormatCode(businessFormatCode);
        int k = 1;
        while (true) {
            Page<TerminalVo> terPage = terminalVoService.findBaseByDto(PageRequest.of(k, 2000), terDto);
            if (Objects.isNull(terPage) || CollectionUtils.isEmpty(terPage.getRecords())) {
                break;
            }
            Map<String, TerminalVo> terMap = terPage.getRecords().stream()
                    .filter(item -> StringUtil.isNotBlank(item.getCustomerRetailerCode()) && StringUtil.isNotBlank(item.getRegionCode()))
                    .collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (outTer, newTer) -> newTer));
            //105数据统计折扣金额
            SurplusFeePoolBalanceAuditMatchDto discountDto = new SurplusFeePoolBalanceAuditMatchDto();
            discountDto.setYearAndMonth(yearMonth.replaceAll("-", ""));
            List<List<String>> scCodes = Lists.partition(new ArrayList<>(terMap.keySet()),500);
            discountDto.setServiceCodeList(scCodes);
            List<SurplusFeePoolBalanceAuditMatchVo> matchVoList = auditSapVoService.surplusFeePoolBalance(discountDto);
            Map<String, BigDecimal> matchMap;
            if (CollectionUtils.isEmpty(matchVoList)) {
                k++;
                continue;
            } else {
                matchMap = matchVoList.stream().collect(Collectors.toMap(SurplusFeePoolBalanceAuditMatchVo::getServiceCode, SurplusFeePoolBalanceAuditMatchVo::getDiscountAmount));
            }
            //组装数据
            for (String s : terMap.keySet()) {
                TerminalVo ter = terMap.get(s);
                String key1 = ter.getCustomerRetailerCode() + "-" + ter.getRegionCode();
                if (matchMap.containsKey(s)) {
                    BigDecimal b = matchMap.get(s);
                    if (disMap.containsKey(key1)) {
                        BigDecimal dis = disMap.get(key1).add(b);
                        disMap.put(key1, dis);
                    } else {
                        disMap.put(key1, b);
                    }
                }
            }
            k++;

//            Map<String, List<SurplusFeePoolBalanceAuditMatchVo>> matchMap;
//            if (CollectionUtils.isEmpty(matchVoList)) {
//                continue;
//            } else {
//                matchMap = matchVoList.stream().collect(Collectors.groupingBy(SurplusFeePoolBalanceAuditMatchVo::getServiceCode));
//            }
//            //组装数据
//            for (String s : terMap.keySet()) {
//                TerminalVo ter = terMap.get(s);
//                String key1 = ter.getCustomerRetailerCode() + "-" + ter.getRegionCode();
//                if (matchMap.containsKey(s)) {
//                    List<SurplusFeePoolBalanceAuditMatchVo> matchVos = matchMap.get(s);
//                    for (SurplusFeePoolBalanceAuditMatchVo vo : matchVos) {
//                        String key2 = key1 + "-" + vo.getProductBrandCode();
//                        if (disMap.containsKey(key2)) {
//                            BigDecimal dis = disMap.get(key2).add(vo.getDiscountAmount());
//                            disMap.put(key2, dis);
//                        } else {
//                            disMap.put(key2, vo.getDiscountAmount());
//                        }
//                    }
//                }
//            }
//            k++;
        }
    }

}
