package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.DiscountAccountFeeGroupVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.SurplusFeePoolSoldBalance;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.SurplusFeePoolSoldBalanceRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolSoldBalanceService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.constant.DiscountRateConstant;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolSoldBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.SurplusFeePoolSoldBalanceSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolSoldBalanceVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.SurplusFeePoolBalanceAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.enums.AssociationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class SurplusFeePoolSoldBalanceServiceImpl implements SurplusFeePoolSoldBalanceService,SurplusFeePoolSoldBalanceSdkService {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired
    private SurplusFeePoolSoldBalanceRepository surplusFeePoolSoldBalanceRepository;

    @Autowired(required = false)
    private TpmExamineCircularService tpmExamineCircularService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    //分页参数
    private final static int pageSize = 2000;

    @Override
    @Transactional
    public void createSurplusFeePoolSoldBalance(ActivityDetailPlanItemStatisticsDto dto) {
        if (dto.getFeeYearMonth() == null) {
            log.error("获取到当前年月为空");
            return;
        }
        //设置上一个月时间 （重新赋值）
        dto.setFeeYearMonth(DateUtil.offsetMonth(dto.getFeeYearMonth(),-1));
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEndCaseForm(EndCaseFormEnum.DISCOUNT.getCode());

        Pageable pageable = PageRequest.of(1, pageSize);
        //分页获取上月的
        Page<DiscountAccountFeeGroupVo> feeGroupVoPage = buildSurplusFeePoolSoldBalance(dto, pageable);

        long total = feeGroupVoPage.getTotal();
        if (total > pageSize) {
            long num = total / pageSize;
            if (total % pageSize > 0) {
                num += 1;
            }
            for (int i=2; i<=num; i++) {
                pageable = PageRequest.of(i, pageSize);
                buildSurplusFeePoolSoldBalance(dto, pageable);
            }
        }

    }

    private Page<DiscountAccountFeeGroupVo> buildSurplusFeePoolSoldBalance(ActivityDetailPlanItemStatisticsDto dto, Pageable pageable) {
        Page<DiscountAccountFeeGroupVo> feeGroupVoPage = activityDetailPlanItemSdkService.findPageStatisDiscountAccountFee(dto, pageable);
        List<DiscountAccountFeeGroupVo> records = feeGroupVoPage.getRecords();
        if (ObjectUtils.isNotEmpty(records)) {
            Map<String, String> regionMap = this.dictToolkitService.findMapByDictTypeCode(DiscountRateConstant.MDM_CUSTOMIZE_ORG);
            List<SurplusFeePoolSoldBalance> list = new ArrayList<>();
            records.stream().forEach(record ->{
                //业态+业务单元+零售商+区域+售达方+年月
                String onlyKey = StringUtils.joinWith("-", record.getBusinessFormatCode(), record.getBusinessUnitCode(), record.getSystemCode(), record.getRegionCode(),
                        record.getSoldCode(), record.getYearMonthStr());
                SurplusFeePoolSoldBalance soldBalance = surplusFeePoolSoldBalanceRepository.findSurplusFeePoolSoldBalance(onlyKey);
                if (soldBalance == null) {
                    soldBalance = new SurplusFeePoolSoldBalance();
                    BeanUtils.copyProperties(record, soldBalance);
                    soldBalance.setOnlyKey(onlyKey);
                    soldBalance.setTenantCode(TenantUtils.getTenantCode());
                    soldBalance.setRegionName(regionMap.getOrDefault(record.getRegionCode(), null));
                }

                //获取考核扣款
                SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto = new SurplusFeePoolBalanceAssessedAmountStatisticsDto();
                assessDto.setBusinessFormatCode(record.getBusinessFormatCode());
                assessDto.setBusinessUnitCode(record.getBusinessUnitCode());
                assessDto.setFeeYearMonth(dto.getFeeYearMonth());
                assessDto.setRegionCode(record.getRegionCode());
                assessDto.setSystemCode(record.getSystemCode());
                assessDto.setSoldCode(record.getSoldCode());
                assessDto.setRelationType(AssociationTypeEnum.EXPENSE_POOL.getCode());
                assessDto.setTenantCode(TenantUtils.getTenantCode());
                BigDecimal examineMoney = tpmExamineCircularService.getExamineMoney(assessDto);

                //105数据折扣金额在ect同步数据的时候扣减
                BigDecimal sapMoney = BigDecimal.ZERO;
                //获取上月的剩余金额
                String lastOnlyKey = StringUtils.joinWith("-", record.getBusinessFormatCode(), record.getBusinessUnitCode(), record.getSystemCode(), record.getRegionCode(),
                        record.getSoldCode(), DateUtil.format(DateUtil.offsetMonth(dto.getFeeYearMonth(),-1), DatePattern.NORM_MONTH_PATTERN));
                SurplusFeePoolSoldBalance lastSoldBalance = surplusFeePoolSoldBalanceRepository.findSurplusFeePoolSoldBalance(lastOnlyKey);
                BigDecimal lastMonthMoney = BigDecimal.ZERO;
                if (lastSoldBalance != null) {
                    lastMonthMoney = lastSoldBalance.getBalance();
                    soldBalance.setParentOnlyKey(lastSoldBalance.getOnlyKey());
                }
                //计算最终的金额
                soldBalance.setBalance(record.getBalance().add(examineMoney).add(sapMoney).add(lastMonthMoney));
                list.add(soldBalance);
            });
            if (ObjectUtils.isNotEmpty(list)) {
                surplusFeePoolSoldBalanceRepository.saveOrUpdateBatch(list);
            }
        }
        return feeGroupVoPage;
    }

    @Override
    @Transactional
    public void continueLastMonthSurplusFeePoolSoldeBalance() {
        //找寻上个月有的数据，这个月没有的数据，沿用到下一个月 (当前是找寻的，上月和上上月数据)
        SurplusFeePoolSoldBalanceDto dto = new SurplusFeePoolSoldBalanceDto();
        dto.setYearMonth(DateUtil.offsetMonth(DateUtil.date(), -1));
        dto.setLastYearMonth(DateUtil.offsetMonth(DateUtil.date(), -2));

        Pageable pageable = PageRequest.of(1, pageSize);
        //分页获取数据
        Page<SurplusFeePoolSoldBalance> balancePage = buildNewSurplusFeePoolSoldeBalance(dto, pageable);

        long total = balancePage.getTotal();
        if (total > pageSize) {
            long num = total / pageSize;
            if (total % pageSize > 0) {
                num += 1;
            }
            for (int i=2; i<=num; i++) {
                pageable = PageRequest.of(i, pageSize);
                buildNewSurplusFeePoolSoldeBalance(dto, pageable);
            }
        }

    }

    private Page<SurplusFeePoolSoldBalance> buildNewSurplusFeePoolSoldeBalance(SurplusFeePoolSoldBalanceDto dto, Pageable pageable) {
        Page<SurplusFeePoolSoldBalance> balancePage = surplusFeePoolSoldBalanceRepository.continueLastMonthSurplusFeePoolSoldeBalance(pageable, dto);

        List<SurplusFeePoolSoldBalance> records = balancePage.getRecords();
        if (ObjectUtils.isNotEmpty(records)) {
            List<SurplusFeePoolSoldBalance> list = new ArrayList<>();
            records.stream().forEach(record ->{
                SurplusFeePoolSoldBalance soldBalance = new SurplusFeePoolSoldBalance();
                BeanUtils.copyProperties(record, soldBalance, new String[]{"id", "createTime", "modifyTime"});
                //复制后修改年月
                soldBalance.setYearMonthStr(DateUtil.format(dto.getYearMonth(), DatePattern.NORM_MONTH_PATTERN));

                //业态+业务单元+零售商+区域+售达方+年月
                String onlyKey = StringUtils.joinWith("-", record.getBusinessFormatCode(), record.getBusinessUnitCode(), record.getSystemCode(), record.getRegionCode(),
                        record.getSoldCode(), soldBalance.getYearMonthStr());
                soldBalance.setOnlyKey(onlyKey);
                list.add(soldBalance);
            });
            if (ObjectUtils.isNotEmpty(list)) {
                surplusFeePoolSoldBalanceRepository.saveOrUpdateBatch(list);
            }
        }
        return balancePage;
    }

    @Override
    public Page<SurplusFeePoolSoldBalanceVo> findByConditions(Pageable pageable, SurplusFeePoolSoldBalanceDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, pageSize));
        //获取当前月份的数据
        return surplusFeePoolSoldBalanceRepository.findByConditions(pageable, dto);
    }

}
