package com.biz.crm.tpm.business.budget.discount.rate.local.variable.register;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: 折前销售额变量注册器
 */
@Service
@Slf4j
public class NextMonthDiscountBeforeSalesVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "ZQXSE";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "折前销售额";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 4;
    }

    /**
     * 变量类型
     *
     * @return 变量排序
     */
    @Override
    public String getType() {
        return BusinessUnitEnum.VERTICAL.getCode();
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        Validate.notBlank(calculateDto.getCustomerRetailerCode(), "零售商编码不能为空");
        Validate.notBlank(calculateDto.getRegionCode(), "区域编码不能为空");
        Validate.notBlank(calculateDto.getBrandCode(), "品牌编码不能为空");
        //TODO 下月事中活动申请金额（活动形式上“核销方式”为“事中”且费用所属年月为下月的审批通过状态细案的申请金额

        return new BigDecimal(100);
    }

    /**
     * 根据条件获取变量值(批量)
     *
     * @param calculateDto 计算条件
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> calculateVariableBatch(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        //在销售任务管理这个表里面，业态：常温；业务单元：垂直；年度任务分类：内控，通过年月，零售商编码+区域编码 过滤下的数据
        if (StringUtils.isBlank(calculateDto.getBusinessFormatCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(calculateDto.getBusinessUnitCode())) {
            return new HashMap<>();
        }
        SalesGoalDiscountSalesStatisticsDto dto = new SalesGoalDiscountSalesStatisticsDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        //这里时间取上月的
        dto.setYearMonth(DateUtil.dateToStr(calculateDto.getYearAndMonth(),DateUtil.date_yyyy_MM));
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
        return salesGoalService.getSalesBeforeDiscount(dto);
    }
}
