package com.biz.crm.tpm.business.budget.discount.rate.local.variable.register;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: 下月事中费用变量注册器
 */
@Service
@Slf4j
public class NextMonthMiddleFeeVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "XYSZFY";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "下月事中费用";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 变量类型
     *
     * @return 变量排序
     */
    @Override
    public String getType() {
        return BusinessUnitEnum.VERTICAL.getCode();
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        return new BigDecimal(0);
    }

    /**
     * 根据条件获取变量值(批量)
     *
     * @param calculateDto 计算条件
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> calculateVariableBatch(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        if (StringUtils.isBlank(calculateDto.getBusinessFormatCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(calculateDto.getBusinessUnitCode())) {
            return new HashMap<>();
        }
        ActivityDetailPlanItemStatisticsDto dto = new ActivityDetailPlanItemStatisticsDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setFeeYearMonth(calculateDto.getYearAndMonth());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setWriteOffMethod(WriteOffMethodEnum.THINGS.getCode());
        //下月事中费用 =  活动细案明细 费用年月+ 核销方式事中 +细案审批通过+费用合计
        if (!calculateDto.getAllTag()) {
            if (CollectionUtils.isEmpty(calculateDto.getCustomerRetailerCodeList()) ||
                    CollectionUtils.isEmpty(calculateDto.getRegionCodeList())) {
                return new HashMap<>();
            }
            dto.setCustomerRetailerCodeList(calculateDto.getCustomerRetailerCodeList());
            dto.setRegionCodeList(calculateDto.getRegionCodeList());
//            dto.setBrandCodeList(calculateDto.getBrandCodeList());
        }
        return activityDetailPlanItemSdkService.statisticsDetailPlanItemTotalFee(dto);
    }
}
