package com.biz.crm.tpm.business.budget.discount.rate.local.variable.register;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: 下月预计上账费用变量注册器
 */
@Service
@Slf4j
public class NextMonthRedTicketVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "CYHP";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "次月红票";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 9;
    }

    /**
     * 变量类型
     *
     * @return 变量排序
     */
    @Override
    public String getType() {
        return BusinessUnitEnum.VERTICAL.getCode();
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        Validate.notBlank(calculateDto.getCustomerRetailerCode(), "零售商编码不能为空");
        Validate.notBlank(calculateDto.getRegionCode(), "区域编码不能为空");
        Validate.notBlank(calculateDto.getBrandCode(), "品牌编码不能为空");
        //TODO 下往月未核销活动预结案金额-已结案金额

        return new BigDecimal(200);
    }

    /**
     * 根据条件获取变量值(批量)
     *
     * @param calculateDto 计算条件
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> calculateVariableBatch(CalculateDto calculateDto) {
        //次月红票：
        // 活动细案明细中的 费用归属年月是当前月及以前月份
        // 细案预测表 预估核销金额
        // 结案核销明细 已审批 未上账 结案形式为红票  1、未结案的活动：预核销金额，2、部分结案的活动：预核销金额-已上账金额，3、完全结案的活动：不取
        // 分摊规则：
        //如果方案申请已到产品维度，则不需要对费用进行分摊；
        //如果方案申请未到产品维度，但申请时已设立分摊比例（活动明细上有关联表），则需按照分摊比例分摊；  此条规则目前不会使用，因为目前没有分摊规则
        //如果方案申请未到产品维度，且申请时未设立分摊比例（活动明细上有关联表），则需根据品牌、品类、品项对应该零售商+区域单品折后销售额占比进行分摊（单品折后销售额从《垂直销售业绩》表取数）；
        Validate.notNull(calculateDto, "输入参数不能为空");
        if (StringUtils.isBlank(calculateDto.getBusinessFormatCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(calculateDto.getBusinessUnitCode())) {
            return new HashMap<>();
        }
        ActivityDetailPlanItemStatisticsDto dto = new ActivityDetailPlanItemStatisticsDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setFeeYearMonth(calculateDto.getYearAndMonth());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEndCaseForm(EndCaseFormEnum.RED_INVOICE.getCode());
        if (!calculateDto.getAllTag()) {
            if (CollectionUtils.isEmpty(calculateDto.getCustomerRetailerCodeList()) ||
                    CollectionUtils.isEmpty(calculateDto.getRegionCodeList())) {
                return new HashMap<>();
            }
            dto.setCustomerRetailerCodeList(calculateDto.getCustomerRetailerCodeList());
            dto.setRegionCodeList(calculateDto.getRegionCodeList());
//            dto.setBrandCodeList(calculateDto.getBrandCodeList());
        }
        return activityDetailPlanItemSdkService.statisNextMonthPredictAccountFee(dto);
    }
}
