package com.biz.crm.tpm.business.budget.discount.rate.local.variable.register;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: 预计随车折扣额变量注册器
 */
@Service
@Slf4j
public class PredictCarFeeVariableRegister implements FormulaVariableRegister {

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "YJSCZKE";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "预计随车折扣额";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 7;
    }

    /**
     * 变量类型
     *
     * @return 变量排序
     */
    @Override
    public String getType() {
        return BusinessUnitEnum.HEADQUARTERS.getCode();
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        Validate.notNull(calculateDto.getPredictCarFee(), "预计随车折扣额不能为空");
        return calculateDto.getPredictCarFee();
    }

    /**
     * 根据条件获取变量值(批量)
     *
     * @param calculateDto 计算条件
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> calculateVariableBatch(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        return new HashMap<>();
    }
}
