package com.biz.crm.tpm.business.budget.discount.rate.local.variable.register;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolBalanceService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.SurplusFeePoolBalanceAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.enums.AssociationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: 剩余费用池余额变量注册器
 */
@Service
@Slf4j
public class SurplusFeePoolBalanceVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SurplusFeePoolBalanceService surplusFeePoolBalanceService;
    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required = false)
    private TpmExamineCircularService tpmExamineCircularService;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "SYFYCYE";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "剩余费用池余额";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 3;
    }

    /**
     * 变量类型
     *
     * @return 变量排序
     */
    @Override
    public String getType() {
        return BusinessUnitEnum.VERTICAL.getCode();
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        return new BigDecimal(300);
    }

    /**
     * 根据条件获取变量值(批量)
     *
     * @param calculateDto 计算条件
     * @return Map<String, BigDecimal>
     */
    @Override
    public Map<String, BigDecimal> calculateVariableBatch(CalculateDto calculateDto) {
        //费用池余额=期初+上账金额-考核扣款金额-折扣金额
        //剩余费用池余额表 期初
        // 活动细案明细中的 费用归属年月是当前月
        // 细案预测表->结案核销明细 结案形式为折扣 折扣上账金额
        // 考核通报明细 分摊金额
        // kms 105数据 折扣金额=交货单折后金额-发票金额

        Validate.notNull(calculateDto, "输入参数不能为空");
        if (StringUtils.isBlank(calculateDto.getBusinessFormatCode())) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(calculateDto.getBusinessUnitCode())) {
            return new HashMap<>();
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(calculateDto.getYearAndMonth());
        calendar.add(Calendar.MONTH, -1);
        String lastYearMonthStr = DateUtil.dateToStr(calendar.getTime(), DateUtil.date_yyyy_MM);

        //获取期初金额
        SurplusFeePoolBalanceDto balanceDto = new SurplusFeePoolBalanceDto();
        balanceDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        balanceDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        balanceDto.setYearMonthStr(lastYearMonthStr);
        Map<String, BigDecimal> periodMap = surplusFeePoolBalanceService.getAmountByDate(balanceDto);
        //获取上账金额
        ActivityDetailPlanItemStatisticsDto dto = new ActivityDetailPlanItemStatisticsDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setFeeYearMonth(calendar.getTime());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEndCaseForm(EndCaseFormEnum.DISCOUNT.getCode());
        if (!calculateDto.getAllTag()) {
            if (CollectionUtils.isEmpty(calculateDto.getCustomerRetailerCodeList()) ||
                    CollectionUtils.isEmpty(calculateDto.getRegionCodeList())) {
                return new HashMap<>();
            }
            dto.setCustomerRetailerCodeList(calculateDto.getCustomerRetailerCodeList());
            dto.setRegionCodeList(calculateDto.getRegionCodeList());
//            dto.setBrandCodeList(calculateDto.getBrandCodeList());
        }
        Map<String, BigDecimal> accountMap = activityDetailPlanItemSdkService.statisDiscountAccountFee(dto);
        //获取考核扣款
        SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto = new SurplusFeePoolBalanceAssessedAmountStatisticsDto();
        assessDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        assessDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        assessDto.setFeeYearMonth(calendar.getTime());
        assessDto.setRelationType(AssociationTypeEnum.EXPENSE_POOL.getCode());
        Map<String, BigDecimal> assessMap = tpmExamineCircularService.statisAssessDeduction(assessDto);
        //TODO 折扣转报销 还没功能，目前做不了

        //获取105数据折扣金额
        Map<String, BigDecimal> disMap = new HashMap<>();
        this.surplusFeePoolBalanceService.get105Discount(disMap, calculateDto.getBusinessUnitCode(), calculateDto.getBusinessFormatCode(), lastYearMonthStr);
        //组装数据
        Map<String, BigDecimal> finallyMap = new HashMap<>();

        Set<String> splicingCodeSet = new HashSet<>();
        if(!periodMap.isEmpty()){
            log.error("periodMap的key[{}]",periodMap.keySet());
            splicingCodeSet.addAll(periodMap.keySet());
        }
        if (!accountMap.isEmpty()) {
            log.error("accountMap的key[{}]",accountMap.keySet());
            splicingCodeSet.addAll(accountMap.keySet());
        }
        if (!assessMap.isEmpty()) {
            log.error("assessMap的key[{}]",assessMap.keySet());
            splicingCodeSet.addAll(assessMap.keySet());
        }
        if (!disMap.isEmpty()) {
            log.error("disMap的key[{}]",disMap.keySet());
            splicingCodeSet.addAll(disMap.keySet());
        }
//        Set<String> splicingCodeSet = periodMap.keySet();
//        if (!accountMap.isEmpty()) {
//            splicingCodeSet.addAll(accountMap.keySet());
//        }
//        if (!assessMap.isEmpty()) {
//            splicingCodeSet.addAll(assessMap.keySet());
//        }
//        if (!disMap.isEmpty()) {
//            splicingCodeSet.addAll(disMap.keySet());
//        }
        for (String s : splicingCodeSet) {
            BigDecimal b = BigDecimal.ZERO;
            b = b.add(periodMap.getOrDefault(s, BigDecimal.ZERO));
            b = b.add(accountMap.getOrDefault(s, BigDecimal.ZERO));
            b = b.add(assessMap.getOrDefault(s, BigDecimal.ZERO));
            b = b.subtract(disMap.getOrDefault(s, BigDecimal.ZERO));
            finallyMap.put(s, b);
        }
        return finallyMap;
    }
}
