package com.biz.crm.tpm.business.budget.discount.rate.local.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2023/2/18 15:36
 * @description: 垂直折扣率自动计算定时任务
 */
@Slf4j
@Service
public class VerticalDiscountRateCalXxJob {

    @Autowired(required = false)
    private DiscountRateService discountRateService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 垂直折扣率自动计算定时任务,每月28号执行,生成下月折扣率
     */
    @DynamicTaskService(cornExpression = "0 0 3 27 * ?", taskDesc = "垂直折扣率自动计算定时任务")
    public void verticalDiscountRateCalXxJob() {
        loginUserService.refreshAuthentication(null);

        log.info("=====>    垂直折扣率自动计算定时任务[{}] start    <=====", DateUtil.dateStrNowAll());
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH,1);
        String yearMonth = DateUtil.dateToStr(calendar.getTime(),DateUtil.date_yyyy_MM);
        discountRateService.verticalDiscountRateCal(yearMonth);
        log.info("=====>    垂直折扣率自动计算定时任务[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
