package com.biz.crm.tpm.business.budget.discount.rate.local.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolBalanceService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;

/**
 * @author: chenlong
 * @date: 2023/2/18 15:36
 * @description: 垂直剩余费用池余额自动计算定时任务
 */
@Slf4j
@Service
public class VerticalSurplusFeePoolBalanceCalXxJob {

    @Autowired(required = false)
    private SurplusFeePoolBalanceService surplusFeePoolBalanceService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 垂直剩余费用池余额自动计算定时任务,每月1号执行，生成当月的期初数据
     */
    @DynamicTaskService(cornExpression = "0 0 3 1 * ?", taskDesc = "垂直剩余费用池余额自动计算定时任务")
    public void verticalSurplusFeePoolBalanceCalXxJob() {
        loginUserService.refreshAuthentication(null);

        log.info("=====>    垂直折扣率自动计算定时任务[{}] start    <=====", DateUtil.dateStrNowAll());
        String yearMonth = DateUtil.dateToStr(DateUtil.date_yyyy_MM);
        surplusFeePoolBalanceService.verticalSurplusFeePoolBalanceCal(yearMonth);
        log.info("=====>    垂直折扣率自动计算定时任务[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
