package com.biz.crm.tpm.business.budget.discount.rate.local.xxjob;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolSoldBalanceService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Slf4j
@Service
public class VerticalSurplusFeePoolSoldBalanceCalXxJob {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired
    private SurplusFeePoolSoldBalanceService surplusFeePoolSoldBalanceService;

    @DynamicTaskService(cornExpression = "0 0 3 1 * ?", taskDesc = "垂直剩余费用池余额自动计算定时任务(系统+售达方+大区)")
    public void autoSurplusFeePoolSoldeBalanceXxJob() {
        log.info("=====>    垂直剩余费用池余额自动计算定时任务(系统+售达方+大区)[{}] start    <=====", DateUtil.now());
        loginUserService.refreshAuthentication(null);
        ActivityDetailPlanItemStatisticsDto dto = new ActivityDetailPlanItemStatisticsDto();
        dto.setFeeYearMonth(new Date());
        surplusFeePoolSoldBalanceService.createSurplusFeePoolSoldBalance(dto);
        log.info("=====>    垂直剩余费用池余额自动计算定时任务(系统+售达方+大区)[{}] end    <=====", DateUtil.now());
    }

    @DynamicTaskService(cornExpression = "0 30 4 1 * ?", taskDesc = "垂直剩余费用池余额上个月沿用定时任务")
    public void autoContinueLastMonthSurplusFeePoolSoldeBalanceXxJob() {
        log.info("=====>    垂直剩余费用池余额上个月沿用定时任务[{}] start    <=====", DateUtil.now());
        loginUserService.refreshAuthentication(null);
        surplusFeePoolSoldBalanceService.continueLastMonthSurplusFeePoolSoldeBalance();
        log.info("=====>    垂直剩余费用池余额上个月沿用定时任务[{}] end    <=====", DateUtil.now());
    }

}
