/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolBalanceService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateBudgetDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRatePlanCalDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateProcessDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateRecalDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateBudgetVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/discountRate"})
@Api(tags={"\u6298\u6263\u7387\u7ba1\u7406"})
public class DiscountRateController {
    private static final Logger log = LoggerFactory.getLogger(DiscountRateController.class);
    @Autowired(required=false)
    private DiscountRateService discountRateService;
    @Autowired(required=false)
    private DiscountRateSdkService discountRateSdkService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SurplusFeePoolBalanceService surplusFeePoolBalanceService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<DiscountRateVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="rateDto", value="\u6298\u6263\u7387Dto") DiscountRateDto rateDto) {
        try {
            Page page = this.discountRateSdkService.findByConditions(pageable, rateDto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<DiscountRateVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            DiscountRateVo rateVo = this.discountRateService.findById(id);
            return Result.ok((Object)rateVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.discountRateService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.discountRateService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.discountRateService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"submitApproval"})
    public Result<?> submitApproval(@ApiParam(name="processDto", value="\u63d0\u4ea4\u5ba1\u6279dto") @RequestBody DiscountRateProcessDto processDto) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            Validate.notNull((Object)processDto.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01", (Object[])new Object[0]);
            lockKey = "discount_rate:lock:approve:" + processDto.getId();
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 1L);
            Validate.isTrue((boolean)lockSuccess, (String)"\u6b64\u6298\u6263\u7387\u6b63\u5728\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4", (Object[])new Object[0]);
            this.discountRateService.submitApproval(processDto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u66f4\u65b0\u8ba1\u7b97")
    @PostMapping(value={"recal"})
    public Result<?> recal(@ApiParam(name="recalDto", value="\u66f4\u65b0\u8ba1\u7b97dto") @RequestBody DiscountRateRecalDto recalDto) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            lockKey = "discount_rate:lock:approve:";
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 1L);
            Validate.isTrue((boolean)lockSuccess, (String)"\u5df2\u6709\u66f4\u65b0\u8ba1\u7b97\u4efb\u52a1\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u7b49", (Object[])new Object[0]);
            this.discountRateService.recal(recalDto);
            Result result = Result.ok((String)"\u66f4\u65b0\u8ba1\u7b97\u4efb\u52a1\u5df2\u5f00\u59cb");
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @ApiOperation(value="\u5782\u76f4\u6839\u636e\u9884\u7b97\u83b7\u53d6\u6298\u6263\u7387")
    @PostMapping(value={"getDiscountRateByDimensionCode"})
    public Result<Map<String, DiscountRateBudgetVo>> getDiscountRateByDimensionCode(@ApiParam(name="budgetDtoList", value="\u6298\u6263\u7387\u9884\u7b97dto\u5217\u8868") @RequestBody List<DiscountRateBudgetDto> budgetDtoList) {
        try {
            Map map = this.discountRateSdkService.getDiscountRateByDimensionCode(budgetDtoList);
            return Result.ok((Object)map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9500\u552e\u8ba1\u5212\u83b7\u53d6\u6298\u6263\u7387")
    @PostMapping(value={"findRateByPlanConditions"})
    public Result<List<DiscountRateDto>> findRateByPlanConditions(@RequestBody DiscountRatePlanCalDto calDto) {
        try {
            List list = this.discountRateSdkService.findRateByPlanConditions(calDto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u5b9a\u65f6\u4efb\u52a1\u81ea\u52a8\u751f\u6210\u6298\u6263\u7387")
    @PostMapping(value={"textVerticalDiscountRateCal"})
    public Result<?> textVerticalDiscountRateCal(@RequestParam(value="yearMonth") String yearMonth) {
        try {
            this.discountRateService.verticalDiscountRateCal(yearMonth);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u5b9a\u65f6\u4efb\u52a1\u81ea\u52a8\u751f\u6210\u671f\u521d")
    @GetMapping(value={"textVerticalSurplusFeePoolBalanceCal"})
    public Result<?> textVerticalSurplusFeePoolBalanceCal(@RequestParam(value="yearMonth") String yearMonth) {
        try {
            this.surplusFeePoolBalanceService.verticalSurplusFeePoolBalanceCal(yearMonth);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

