/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.listener;

import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscountRateProcessCompleteListener
implements ProcessCompleteListener {
    @Autowired(required=false)
    private DiscountRateService discountRateService;

    public String getBusinessCode() {
        return "discount_rate_process";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.discountRateService.processPass(dto);
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.discountRateService.processRejectAndRecover(dto);
        }
    }
}

