/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerOrgChannelStoresVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateConfigService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateVariableService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateCustomerImportVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.enums.SummaryDimensionEunm;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscountRateCustomerImportProcess
implements ImportProcess<DiscountRateCustomerImportVo> {
    private static final Logger log = LoggerFactory.getLogger(DiscountRateCustomerImportProcess.class);
    @Autowired(required=false)
    private DiscountRateService discountRateService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private DiscountRateVariableService discountRateVariableService;
    @Autowired(required=false)
    private DiscountRateConfigService discountRateConfigService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;

    public Integer getBatchCount() {
        return 50001;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, DiscountRateCustomerImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, DiscountRateCustomerImportVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            DiscountRateCustomerImportVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getRateVersion()), "\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessDepartment()), "\u4e1a\u52a1\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getYearAndMonthStr()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, DiscountRateCustomerImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= 50000 ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc750000\u6761", (Object[])new Object[0]);
        List<DiscountRateDto> importList = this.validate(data, errMap);
        if (errMap.isEmpty()) {
            log.error("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------");
            this.discountRateService.bulkImportSave(importList);
            log.error("\u5bfc\u5165\u903b\u8f91\u5904\u7406\u5b8c\u6bd5-----------------");
        }
        return errMap;
    }

    private List<DiscountRateDto> validate(LinkedHashMap<Integer, DiscountRateCustomerImportVo> data, Map<Integer, String> errMap) {
        ArrayList<DiscountRateDto> list = new ArrayList<DiscountRateDto>();
        Map unitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Map departMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_business_department");
        Map versionMap = this.dictToolkitService.findConvertMapByDictTypeCode("tmp_discount_rate_version");
        String type = DiscountRateDimensionEnum.CUSTOMER.getCode();
        data.forEach((k, v) -> list.add(this.validateData((Integer)k, (DiscountRateCustomerImportVo)v, type, formatMap, unitMap, departMap, versionMap, errMap)));
        if (!errMap.isEmpty()) {
            return new ArrayList<DiscountRateDto>();
        }
        HashSet<String> cusCodes = new HashSet<String>();
        for (DiscountRateDto vo : list) {
            cusCodes.add(vo.getCustomerCode());
        }
        List cusList = Lists.partition(new ArrayList(cusCodes), (int)500);
        Map cusMap = this.customerVoService.getCustomerByCodes(cusList);
        this.validateCorrect(list, cusMap, errMap);
        if (!errMap.isEmpty()) {
            return new ArrayList<DiscountRateDto>();
        }
        return new ArrayList<DiscountRateDto>(list);
    }

    private DiscountRateDto validateData(Integer index, DiscountRateCustomerImportVo dto, String type, Map<String, String> formatMap, Map<String, String> unitMap, Map<String, String> departMap, Map<String, String> versionMap, Map<Integer, String> errMap) {
        String msg;
        DiscountRateDto rate = new DiscountRateDto();
        rate.setBusinessFormatCode(dto.getBusinessFormatCode());
        rate.setBusinessUnitCode(dto.getBusinessUnitCode());
        rate.setRateVersion(dto.getRateVersion());
        rate.setBusinessDepartment(dto.getBusinessDepartment());
        if (formatMap.containsKey(dto.getBusinessFormatCode())) {
            rate.setBusinessFormatCode(formatMap.get(dto.getBusinessFormatCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
        }
        rate.setCustomerErpCode(dto.getCustomerCode());
        rate.setCustomerCode(dto.getCustomerCode() + dto.getSalesInstitutionCode() + dto.getChannelCode() + rate.getBusinessFormatCode());
        if (unitMap.containsKey(dto.getBusinessUnitCode())) {
            rate.setBusinessUnitCode(unitMap.get(dto.getBusinessUnitCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b");
        }
        if (versionMap.containsKey(dto.getRateVersion())) {
            rate.setRateVersion(versionMap.get(dto.getRateVersion()));
        } else {
            this.validateIsTrue(false, "\u7248\u672c\u672a\u80fd\u8bc6\u522b");
        }
        if (departMap.containsKey(dto.getBusinessDepartment())) {
            rate.setBusinessDepartment(departMap.get(dto.getBusinessDepartment()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u52a1\u90e8\u95e8\u672a\u80fd\u8bc6\u522b");
        }
        try {
            rate.setYearAndMonth(DateUtil.date_yyyy_MM.parse(dto.getYearAndMonthStr()));
            rate.setYearAndMonthStr(dto.getYearAndMonthStr());
            if (dto.getYearAndMonthStr().trim().length() != 7) {
                this.validateIsTrue(false, "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
            }
        }
        catch (Exception e) {
            msg = "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011";
            this.validateIsTrue(false, msg);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getSystemRate())) {
            try {
                rate.setSystemRate(BigDecimal.valueOf(Double.parseDouble(dto.getSystemRate())).setScale(6, 1));
                rate.setSystemRateStr(rate.getSystemRate().toPlainString() + "%");
            }
            catch (Exception e) {
                msg = "\u7cfb\u7edf\u6298\u6263\u7387(%)\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                this.validateIsTrue(false, msg);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPlanRate())) {
            try {
                rate.setPlanRate(BigDecimal.valueOf(Double.parseDouble(dto.getPlanRate())).setScale(6, 1));
                rate.setPlanRateStr(rate.getPlanRate().toPlainString() + "%");
            }
            catch (Exception e) {
                msg = "\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387(%)\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                this.validateIsTrue(false, msg);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAdjustSystemRate())) {
            try {
                rate.setAdjustSystemRate(new BigDecimal(Double.parseDouble(dto.getAdjustSystemRate())).setScale(6, 1));
                rate.setAdjustSystemRateStr(rate.getAdjustSystemRate() + "%");
                rate.setSystemRate(rate.getAdjustSystemRate());
                rate.setSystemRateStr(rate.getAdjustSystemRateStr());
                if (new BigDecimal(20).compareTo(rate.getAdjustSystemRate()) < 0 && StringUtils.isBlank((CharSequence)dto.getAdjustReason())) {
                    String msg2 = "\u8bf7\u586b\u5199\u8c03\u6574\u540e\u7cfb\u7edf\u6298\u6263\u7387\uff1e20%\u539f\u56e0";
                    this.validateIsTrue(false, msg2);
                } else {
                    rate.setAdjustReason(dto.getAdjustReason());
                }
            }
            catch (Exception e) {
                msg = "\u8c03\u6574\u540e\u7cfb\u7edf\u6298\u6263\u7387(%)\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                this.validateIsTrue(false, msg);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAdjustPlanRate())) {
            try {
                rate.setAdjustPlanRate(BigDecimal.valueOf(Double.parseDouble(dto.getAdjustPlanRate())).setScale(6, 1));
                rate.setAdjustPlanRateStr(rate.getAdjustPlanRate() + "%");
                rate.setPlanRate(rate.getPlanRate());
                rate.setPlanRateStr(rate.getPlanRateStr());
            }
            catch (Exception e) {
                msg = "\u8c03\u6574\u540e\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387(%)\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                this.validateIsTrue(false, msg);
            }
        }
        if (null == rate.getSystemRate() || null == rate.getPlanRate()) {
            try {
                rate.setPredictDigestionFee(BigDecimal.valueOf(Double.parseDouble(dto.getPredictDigestionFee())));
            }
            catch (Exception e) {
                msg = "\u9884\u8ba1\u6d88\u5316\u8d39\u7528\u6c60\u8d39\u7528\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                this.validateIsTrue(false, msg);
            }
            try {
                rate.setPredictCarFee(BigDecimal.valueOf(Double.parseDouble(dto.getPredictCarFee())));
            }
            catch (Exception e) {
                msg = "\u9884\u8ba1\u968f\u8f66\u6298\u6263\u989d\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                this.validateIsTrue(false, msg);
            }
        }
        rate.setDimensionType(type);
        String onlyKey = rate.getBusinessFormatCode() + rate.getBusinessUnitCode() + rate.getRateVersion() + rate.getBusinessDepartment() + rate.getDimensionType() + rate.getCustomerCode();
        rate.setOnlyKey(onlyKey);
        rate.setLineIndex(index);
        return rate;
    }

    private void validateCorrect(List<DiscountRateDto> list, Map<String, CustomerOrgChannelStoresVo> cusMap, Map<Integer, String> errMap) {
        HashSet<String> cusCodes = new HashSet<String>();
        HashSet<String> formatCodes = new HashSet<String>();
        HashSet<String> unitCodes = new HashSet<String>();
        HashSet<String> onlyKeySet = new HashSet<String>();
        HashSet<String> dateSet = new HashSet<String>();
        HashSet<String> keys = new HashSet<String>();
        for (DiscountRateDto dto : list) {
            if (cusMap.containsKey(dto.getCustomerCode())) {
                CustomerOrgChannelStoresVo storesVo = cusMap.get(dto.getCustomerCode());
                dto.setCustomerName(storesVo.getCustomerName());
                dto.setSalesInstitutionCode(storesVo.getSalesInstitutionCode());
                dto.setSalesInstitutionName(storesVo.getSalesInstitutionName());
                dto.setSalesRegionCode(storesVo.getSalesRegionCode());
                dto.setSalesRegionName(storesVo.getSalesRegionName());
                dto.setSalesOrgCode(storesVo.getSalesOrgCode());
                dto.setSalesOrgName(storesVo.getSalesOrgName());
                dto.setCustomerChannelCode(storesVo.getChannelCode());
                dto.setCustomerChannelName(storesVo.getChannelName());
                dto.setCustomerType(storesVo.getCustomerType());
            } else {
                this.validateIsTrue(false, "\u6839\u636e\u5ba2\u6237\u7f16\u7801+\u9500\u552e\u673a\u6784\u7f16\u7801+\u6e20\u9053\u7f16\u7801+\u4e1a\u6001\u672a\u80fd\u67e5\u627e\u5230\u5ba2\u6237\u4fe1\u606f");
            }
            if (null != dto.getSystemRate() && null != dto.getPlanRate()) continue;
            cusCodes.add(dto.getCustomerCode());
            dateSet.add(DateUtil.dateToStr((Date)dto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM));
            formatCodes.add(dto.getBusinessFormatCode());
            unitCodes.add(dto.getBusinessUnitCode());
            keys.add(dto.getOnlyKey());
            String onlyKey = dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + dto.getRateVersion() + dto.getBusinessDepartment() + dto.getDimensionType();
            onlyKeySet.add(onlyKey);
        }
        Map<String, String> oldMap = this.discountRateService.getIdByKeys(new ArrayList<String>(keys));
        HashMap accountMap = new HashMap();
        SalesPlanSummaryDto summaryDto = new SalesPlanSummaryDto();
        summaryDto.setFormatLsit(new ArrayList(formatCodes));
        summaryDto.setUnitLsit(new ArrayList(unitCodes));
        summaryDto.setMonthLsit(new ArrayList(dateSet));
        List cusList = Lists.partition(new ArrayList(cusCodes), (int)500);
        summaryDto.setCusLsit(cusList);
        summaryDto.setDimen(SummaryDimensionEunm.CUSTOMER.getCode());
        Map replyMap = this.salesPlanService.summaryRecoveryAmount(summaryDto);
        Map<String, DiscountRateConfig> configMap = this.discountRateConfigService.getConfigByOnlyKeys(new ArrayList<String>(onlyKeySet));
        log.error("\u5f00\u59cb\u6267\u884c\u6298\u6263\u7387\u8ba1\u7b97-----------------");
        for (DiscountRateDto dto : list) {
            String errInfo;
            if (oldMap.containsKey(dto.getOnlyKey())) {
                dto.setId((String)oldMap.getOrDefault(dto.getOnlyKey(), null));
            }
            if (null != dto.getSystemRate() && null != dto.getPlanRate()) continue;
            String key = dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + DateUtil.dateToStr((Date)dto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM) + dto.getCustomerCode();
            if (!accountMap.containsKey(key)) {
                dto.setPredictAccountFee(BigDecimal.ZERO);
            }
            dto.setPredictAccountFee(accountMap.getOrDefault(key, BigDecimal.ZERO));
            if (!replyMap.containsKey(dto.getCustomerCode())) {
                dto.setRecoveryAmount(BigDecimal.ZERO);
            }
            dto.setRecoveryAmount(replyMap.getOrDefault(key, BigDecimal.ZERO));
            String onlyKey = dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + dto.getRateVersion() + dto.getBusinessDepartment() + dto.getDimensionType();
            if (configMap.containsKey(onlyKey)) {
                String msg;
                BigDecimal b;
                CalculateDto calDto;
                DiscountRateConfig config = configMap.get(onlyKey);
                dto.setApproveTag(config.getApproveTag());
                if (YesOrNoEnum.YES.getCode().equals(config.getApproveTag())) {
                    dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                }
                if (null == dto.getSystemRate()) {
                    calDto = new CalculateDto();
                    calDto.setFormula(config.getSystemRateFormula());
                    calDto.setPredictAccountFee(dto.getPredictAccountFee());
                    calDto.setPredictDigestionFee(dto.getPredictDigestionFee());
                    calDto.setPredictCarFee(dto.getPredictCarFee());
                    calDto.setRecoveryAmount(dto.getRecoveryAmount());
                    try {
                        b = this.discountRateVariableService.singleCalculateExpression(calDto);
                        dto.setSystemRate(b.multiply(BigDecimal.valueOf(100L)).setScale(6, 4));
                        dto.setSystemRateStr(dto.getSystemRate().toPlainString() + "%");
                    }
                    catch (Exception e) {
                        msg = "\u5ba2\u6237[" + dto.getMdgCode() + "]\u8ba1\u7b97\u7cfb\u7edf\u6298\u6263\u7387\u5931\u8d25\uff0c\u6298\u6263\u7387\u914d\u7f6e\u7f16\u7801[" + config.getConfigCode() + "]";
                        this.validateIsTrue(false, msg);
                    }
                }
                if (null == dto.getPlanRate()) {
                    calDto = new CalculateDto();
                    calDto.setFormula(config.getPlanRateFormula());
                    calDto.setPredictAccountFee(dto.getPredictAccountFee());
                    calDto.setPredictDigestionFee(dto.getPredictDigestionFee());
                    calDto.setPredictCarFee(dto.getPredictCarFee());
                    calDto.setRecoveryAmount(dto.getRecoveryAmount());
                    try {
                        b = this.discountRateVariableService.singleCalculateExpression(calDto);
                        dto.setPlanRate(b.multiply(BigDecimal.valueOf(100L)).setScale(6, 4));
                        dto.setPlanRateStr(dto.getPlanRate().toPlainString() + "%");
                    }
                    catch (Exception e) {
                        msg = "\u5ba2\u6237[" + dto.getMdgCode() + "]\u8ba1\u7b97\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387\u5931\u8d25\uff0c\u6298\u6263\u7387\u914d\u7f6e\u7f16\u7801[" + config.getConfigCode() + "]";
                        this.validateIsTrue(false, msg);
                    }
                }
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            errMap.put(dto.getLineIndex(), errInfo);
        }
    }

    public Class<DiscountRateCustomerImportVo> findCrmExcelVoClass() {
        return DiscountRateCustomerImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_DISCOUNT_RATE_IMPORT";
    }

    public String getBusinessName() {
        return "TPM\u6298\u6263\u7387\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "TPM_DISCOUNT_RATE_CUSTOMER_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u6298\u6263\u7387\u5ba2\u6237\u7ef4\u5ea6\u5bfc\u5165\u6a21\u677f";
    }
}

