/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateConfigService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateVariableService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateProductImportVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.enums.SummaryDimensionEunm;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscountRateProductImportProcess
implements ImportProcess<DiscountRateProductImportVo> {
    private static final Logger log = LoggerFactory.getLogger(DiscountRateProductImportProcess.class);
    @Autowired(required=false)
    private DiscountRateService discountRateService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private DiscountRateVariableService discountRateVariableService;
    @Autowired(required=false)
    private DiscountRateConfigService discountRateConfigService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;

    public Integer getBatchCount() {
        return 50001;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, DiscountRateProductImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= 50000 ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc72000\u6761", (Object[])new Object[0]);
        List<DiscountRateDto> importList = this.validate(data);
        this.discountRateService.bulkImportSave(importList);
        return null;
    }

    private List<DiscountRateDto> validate(LinkedHashMap<Integer, DiscountRateProductImportVo> data) {
        ArrayList<DiscountRateDto> list = new ArrayList<DiscountRateDto>();
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Map unitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Map departMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_business_department");
        Map versionMap = this.dictToolkitService.findConvertMapByDictTypeCode("tmp_discount_rate_version");
        String type = DiscountRateDimensionEnum.PRODUCT.getCode();
        data.forEach((k, v) -> list.add(this.validateData(k + 2, (DiscountRateProductImportVo)v, type, formatMap, unitMap, departMap, versionMap)));
        HashSet<String> proCodes = new HashSet<String>();
        for (DiscountRateDto vo : list) {
            proCodes.add(vo.getProductCode());
        }
        List proList = Lists.partition(new ArrayList(proCodes), (int)500);
        Map proMap = this.productVoService.getProductByCodes(proList);
        proCodes.clear();
        this.validateCorrect(list, proMap);
        return new ArrayList<DiscountRateDto>(list);
    }

    private DiscountRateDto validateData(Integer index, DiscountRateProductImportVo dto, String type, Map<String, String> formatMap, Map<String, String> unitMap, Map<String, String> departMap, Map<String, String> versionMap) {
        DiscountRateDto rate = new DiscountRateDto();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), (String)"[\u884c%s]\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (long)index.intValue());
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), (String)"[\u884c%s]\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (long)index.intValue());
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getRateVersion()), (String)"[\u884c%s]\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a", (long)index.intValue());
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessDepartment()), (String)"[\u884c%s]\u4e1a\u52a1\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a", (long)index.intValue());
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getProductCode()), (String)"[\u884c%s]\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (long)index.intValue());
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getYearAndMonthStr()), (String)"[\u884c%s]\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (long)index.intValue());
        rate.setBusinessFormatCode(dto.getBusinessFormatCode());
        rate.setBusinessUnitCode(dto.getBusinessUnitCode());
        rate.setRateVersion(dto.getRateVersion());
        rate.setBusinessDepartment(dto.getBusinessDepartment());
        rate.setProductCode(dto.getProductCode());
        if (formatMap.containsKey(dto.getBusinessFormatCode())) {
            rate.setBusinessFormatCode(formatMap.get(dto.getBusinessFormatCode()));
        } else {
            Validate.isTrue((boolean)false, (String)("\u884c\u53f7\uff1a" + index + ",\u4e1a\u6001\u672a\u80fd\u8bc6\u522b"), (Object[])new Object[0]);
        }
        if (unitMap.containsKey(dto.getBusinessUnitCode())) {
            rate.setBusinessUnitCode(unitMap.get(dto.getBusinessUnitCode()));
        } else {
            Validate.isTrue((boolean)false, (String)("\u884c\u53f7\uff1a" + index + ",\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b"), (Object[])new Object[0]);
        }
        if (versionMap.containsKey(dto.getRateVersion())) {
            rate.setRateVersion(versionMap.get(dto.getRateVersion()));
        } else {
            Validate.isTrue((boolean)false, (String)("\u884c\u53f7\uff1a" + index + ",\u7248\u672c\u672a\u80fd\u8bc6\u522b"), (Object[])new Object[0]);
        }
        if (departMap.containsKey(dto.getBusinessDepartment())) {
            rate.setBusinessDepartment(departMap.get(dto.getBusinessDepartment()));
        } else {
            Validate.isTrue((boolean)false, (String)("\u884c\u53f7\uff1a" + index + ",\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b"), (Object[])new Object[0]);
        }
        try {
            rate.setYearAndMonth(DateUtil.date_yyyy_MM.parse(dto.getYearAndMonthStr()));
            rate.setYearAndMonthStr(dto.getYearAndMonthStr());
        }
        catch (Exception e) {
            String msg = "[\u884c" + index + "]\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011";
            throw new IllegalArgumentException(msg);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getSystemRate())) {
            try {
                rate.setSystemRate(BigDecimal.valueOf(Double.parseDouble(dto.getSystemRate())).setScale(6, 1));
                rate.setSystemRateStr(rate.getSystemRate().toPlainString() + "%");
            }
            catch (Exception e) {
                String msg = "[\u884c" + index + "]\u7cfb\u7edf\u6298\u6263\u7387(%)\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                throw new IllegalArgumentException(msg);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPlanRate())) {
            try {
                rate.setPlanRate(BigDecimal.valueOf(Double.parseDouble(dto.getPlanRate())).setScale(6, 1));
                rate.setPlanRateStr(rate.getPlanRate().toPlainString() + "%");
            }
            catch (Exception e) {
                String msg = "[\u884c" + index + "]\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387(%)\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                throw new IllegalArgumentException(msg);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAdjustSystemRate())) {
            try {
                rate.setAdjustSystemRate(BigDecimal.valueOf(Double.parseDouble(dto.getAdjustSystemRate())).setScale(6, 1));
                rate.setAdjustSystemRateStr(rate.getAdjustSystemRate() + "%");
                rate.setSystemRate(rate.getAdjustSystemRate());
                rate.setSystemRateStr(rate.getAdjustSystemRateStr());
            }
            catch (Exception e) {
                String msg = "[\u884c" + index + "]\u8c03\u6574\u540e\u7cfb\u7edf\u6298\u6263\u7387(%)\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                throw new IllegalArgumentException(msg);
            }
            if (new BigDecimal(20).compareTo(rate.getAdjustSystemRate()) < 0 && StringUtils.isBlank((CharSequence)dto.getAdjustReason())) {
                String msg = "[\u884c" + index + "]\u8bf7\u586b\u5199\u8c03\u6574\u540e\u7cfb\u7edf\u6298\u6263\u7387\uff1e20%\u539f\u56e0";
                throw new IllegalArgumentException(msg);
            }
            rate.setAdjustReason(dto.getAdjustReason());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAdjustPlanRate())) {
            try {
                rate.setAdjustPlanRate(BigDecimal.valueOf(Double.parseDouble(dto.getAdjustPlanRate())).setScale(6, 1));
                rate.setAdjustPlanRateStr(rate.getAdjustPlanRate() + "%");
                rate.setPlanRate(rate.getPlanRate());
                rate.setPlanRateStr(rate.getPlanRateStr());
            }
            catch (Exception e) {
                String msg = "[\u884c" + index + "]\u8c03\u6574\u540e\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387(%)\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                throw new IllegalArgumentException(msg);
            }
        }
        if (null == rate.getSystemRate() || null == rate.getPlanRate()) {
            try {
                rate.setPredictDigestionFee(BigDecimal.valueOf(Double.parseDouble(dto.getPredictDigestionFee())));
            }
            catch (Exception e) {
                String msg = "[\u884c" + index + "]\u9884\u8ba1\u6d88\u5316\u8d39\u7528\u6c60\u8d39\u7528\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                throw new IllegalArgumentException(msg);
            }
            try {
                rate.setPredictCarFee(BigDecimal.valueOf(Double.parseDouble(dto.getPredictCarFee())));
            }
            catch (Exception e) {
                String msg = "[\u884c" + index + "]\u9884\u8ba1\u968f\u8f66\u6298\u6263\u989d\u683c\u5f0f\u9519\u8bef \u4f8b\u301011.78\u3011";
                throw new IllegalArgumentException(msg);
            }
        }
        rate.setLineIndex(index);
        rate.setDimensionType(type);
        String onlyKey = rate.getBusinessFormatCode() + rate.getBusinessUnitCode() + rate.getRateVersion() + rate.getBusinessDepartment() + rate.getDimensionType() + rate.getCustomerCode();
        rate.setOnlyKey(onlyKey);
        return rate;
    }

    private void validateCorrect(List<DiscountRateDto> list, Map<String, String> proMap) {
        ArrayList<String> proCodes = new ArrayList<String>();
        HashSet<String> formatCodes = new HashSet<String>();
        HashSet<String> unitCodes = new HashSet<String>();
        HashSet<String> onlyKeySet = new HashSet<String>();
        HashSet<String> dateSet = new HashSet<String>();
        HashSet<String> keys = new HashSet<String>();
        for (DiscountRateDto dto : list) {
            if (proMap.containsKey(dto.getProductCode())) {
                dto.setProductName(dto.getProductCode());
            } else {
                Validate.isTrue((boolean)false, (String)("\u884c\u53f7\uff1a" + dto.getLineIndex() + ",\u6839\u636e\u4ea7\u54c1\u7f16\u7801\u672a\u80fd\u67e5\u627e\u5230\u4ea7\u54c1\u4fe1\u606f"), (Object[])new Object[0]);
            }
            if (null != dto.getSystemRate() && null != dto.getPlanRate()) continue;
            dateSet.add(DateUtil.dateToStr((Date)dto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM));
            proCodes.add(dto.getProductCode());
            formatCodes.add(dto.getBusinessFormatCode());
            unitCodes.add(dto.getBusinessUnitCode());
            keys.add(dto.getOnlyKey());
            String onlyKey = dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + dto.getRateVersion() + dto.getBusinessDepartment() + dto.getDimensionType();
            onlyKeySet.add(onlyKey);
        }
        Map<String, String> oldMap = this.discountRateService.getIdByKeys(new ArrayList<String>(keys));
        HashMap accountMap = new HashMap();
        SalesPlanSummaryDto summaryDto = new SalesPlanSummaryDto();
        summaryDto.setFormatLsit(new ArrayList(formatCodes));
        summaryDto.setUnitLsit(new ArrayList(unitCodes));
        summaryDto.setMonthLsit(new ArrayList(dateSet));
        List proList = Lists.partition(new ArrayList(proCodes), (int)500);
        summaryDto.setProLsit(proList);
        summaryDto.setDimen(SummaryDimensionEunm.PRODUCT.getCode());
        Map replyMap = this.salesPlanService.summaryRecoveryAmount(summaryDto);
        Map<String, DiscountRateConfig> configMap = this.discountRateConfigService.getConfigByOnlyKeys(new ArrayList<String>(onlyKeySet));
        for (DiscountRateDto dto : list) {
            BigDecimal b;
            CalculateDto calDto;
            if (oldMap.containsKey(dto.getOnlyKey())) {
                dto.setId((String)oldMap.getOrDefault(dto.getOnlyKey(), null));
            }
            if (null != dto.getSystemRate() && null != dto.getPlanRate()) continue;
            String key = dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + DateUtil.dateToStr((Date)dto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM) + dto.getProductCode();
            if (!accountMap.containsKey(dto.getCustomerCode())) {
                dto.setPredictAccountFee(BigDecimal.ZERO);
            }
            dto.setPredictAccountFee(accountMap.getOrDefault(key, BigDecimal.ZERO));
            if (!replyMap.containsKey(dto.getCustomerCode())) {
                dto.setRecoveryAmount(BigDecimal.ZERO);
            }
            dto.setRecoveryAmount(replyMap.getOrDefault(key, BigDecimal.ZERO));
            String onlyKey = dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + dto.getRateVersion() + dto.getBusinessDepartment() + dto.getDimensionType();
            if (!configMap.containsKey(onlyKey)) continue;
            DiscountRateConfig config = configMap.get(onlyKey);
            dto.setApproveTag(config.getApproveTag());
            if (YesOrNoEnum.YES.getCode().equals(config.getApproveTag())) {
                dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            }
            if (null == dto.getSystemRate()) {
                calDto = new CalculateDto();
                calDto.setFormula(config.getSystemRateFormula());
                calDto.setPredictAccountFee(dto.getPredictAccountFee());
                calDto.setPredictDigestionFee(dto.getPredictDigestionFee());
                calDto.setPredictCarFee(dto.getPredictCarFee());
                calDto.setRecoveryAmount(dto.getRecoveryAmount());
                try {
                    b = this.discountRateVariableService.singleCalculateExpression(calDto);
                    dto.setSystemRate(b.multiply(BigDecimal.valueOf(100L)).setScale(6, 4));
                    dto.setSystemRateStr(dto.getSystemRate().toPlainString() + "%");
                }
                catch (Exception e) {
                    String msg = "\u5ba2\u6237[" + dto.getMdgCode() + "]\u8ba1\u7b97\u7cfb\u7edf\u6298\u6263\u7387\u5931\u8d25\uff0c\u6298\u6263\u7387\u914d\u7f6e\u7f16\u7801[" + config.getConfigCode() + "]";
                    throw new IllegalArgumentException(msg);
                }
            }
            if (null != dto.getPlanRate()) continue;
            calDto = new CalculateDto();
            calDto.setFormula(config.getPlanRateFormula());
            calDto.setPredictAccountFee(dto.getPredictAccountFee());
            calDto.setPredictDigestionFee(dto.getPredictDigestionFee());
            calDto.setPredictCarFee(dto.getPredictCarFee());
            calDto.setRecoveryAmount(dto.getRecoveryAmount());
            try {
                b = this.discountRateVariableService.singleCalculateExpression(calDto);
                dto.setPlanRate(b.multiply(BigDecimal.valueOf(100L)).setScale(6, 4));
                dto.setPlanRateStr(dto.getPlanRate().toPlainString() + "%");
            }
            catch (Exception e) {
                String msg = "\u5ba2\u6237[" + dto.getMdgCode() + "]\u8ba1\u7b97\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387\u5931\u8d25\uff0c\u6298\u6263\u7387\u914d\u7f6e\u7f16\u7801[" + config.getConfigCode() + "]";
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public Class<DiscountRateProductImportVo> findCrmExcelVoClass() {
        return DiscountRateProductImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_DISCOUNT_RATE_IMPORT";
    }

    public String getBusinessName() {
        return "TPM\u6298\u6263\u7387\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "TPM_DISCOUNT_RATE_PRODUCT_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u6298\u6263\u7387\u4ea7\u54c1\u7ef4\u5ea6\u5bfc\u5165\u6a21\u677f";
    }
}

