/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.mapper.DiscountRateConfigMapper;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DiscountRateConfigRepository
extends ServiceImpl<DiscountRateConfigMapper, DiscountRateConfig> {
    @Autowired(required=false)
    private DiscountRateConfigMapper discountRateConfigMapper;

    public void updateByIdAndTenantCode(DiscountRateConfig entity, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)entity.getId());
        ((DiscountRateConfigMapper)this.baseMapper).update((Object)entity, (Wrapper)lambdaUpdateWrapper);
    }

    public void updateBatchByIdAndTenantCode(Collection<DiscountRateConfig> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
                lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)item.getId());
                ((DiscountRateConfigMapper)this.baseMapper).update(item, (Wrapper)lambdaUpdateWrapper);
            }
        });
    }

    public Page<DiscountRateConfigVo> findByConditions(Pageable pageable, DiscountRateConfigDto configDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.discountRateConfigMapper.findByConditions((Page<DiscountRateConfigVo>)page, configDto);
    }
}

