/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRate;
import com.biz.crm.tpm.business.budget.discount.rate.local.mapper.DiscountRateMapper;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRatePlanCalDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DiscountRateRepository
extends ServiceImpl<DiscountRateMapper, DiscountRate> {
    @Autowired(required=false)
    private DiscountRateMapper discountRateMapper;

    public Page<DiscountRateVo> findByConditions(Pageable pageable, DiscountRateDto rateDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.discountRateMapper.findByConditions((Page<DiscountRateVo>)page, rateDto);
    }

    public void updateByIdAndTenantCode(DiscountRate entity, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)entity.getId());
        ((DiscountRateMapper)this.baseMapper).update((Object)entity, (Wrapper)lambdaUpdateWrapper);
    }

    public void updateBatchByIdAndTenantCode(Collection<DiscountRate> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
                lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)item.getId());
                ((DiscountRateMapper)this.baseMapper).update(item, (Wrapper)lambdaUpdateWrapper);
            }
        });
    }

    public void bulkSave(List<DiscountRate> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        ((DiscountRateMapper)this.baseMapper).bulkSave(entities);
    }

    public void updateProcessStatus(String code, String processStatus) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(DiscountRate::getDiscountRateCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(DiscountRate::getProcessStatus, (Object)processStatus)).update();
    }

    public List<DiscountRateDto> getDiscountRateByKeys(List<List<String>> keys, String tenantCode) {
        return ((DiscountRateMapper)this.baseMapper).getDiscountRateByKeys(keys, tenantCode);
    }

    public List<DiscountRateDto> getDiscountRateByKeysNoPro(List<List<String>> keys, String tenantCode) {
        return ((DiscountRateMapper)this.baseMapper).getDiscountRateByKeysNoPro(keys, tenantCode);
    }

    public List<DiscountRateDto> findRateByPlanConditions(DiscountRatePlanCalDto calDto) {
        return ((DiscountRateMapper)this.baseMapper).findRateByPlanConditions(calDto);
    }

    public List<DiscountRate> getIdByKeys(List<List<String>> keyList, String tenantCode) {
        if (CollectionUtils.isEmpty(keyList) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        return ((DiscountRateMapper)this.baseMapper).getIdByKeys(keyList, tenantCode);
    }
}

