/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.SurplusFeePoolBalance;
import com.biz.crm.tpm.business.budget.discount.rate.local.mapper.SurplusFeePoolBalanceMapper;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import jodd.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SurplusFeePoolBalanceRepository
extends ServiceImpl<SurplusFeePoolBalanceMapper, SurplusFeePoolBalance> {
    @Autowired(required=false)
    private SurplusFeePoolBalanceMapper surplusFeePoolBalanceMapper;

    public void updateByIdAndTenantCode(SurplusFeePoolBalance entity, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)entity.getId());
        ((SurplusFeePoolBalanceMapper)this.baseMapper).update((Object)entity, (Wrapper)lambdaUpdateWrapper);
    }

    public void updateBatchByIdAndTenantCode(Collection<SurplusFeePoolBalance> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
                lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)item.getId());
                ((SurplusFeePoolBalanceMapper)this.baseMapper).update(item, (Wrapper)lambdaUpdateWrapper);
            }
        });
    }

    public List<SurplusFeePoolBalanceVo> getPoolBalanceByOnlyKeys(List<List<String>> keyList, String tenantCode) {
        if (CollectionUtils.isEmpty(keyList) || StringUtil.isBlank((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        return this.surplusFeePoolBalanceMapper.getPoolBalanceByOnlyKeys(keyList, tenantCode);
    }

    public List<SurplusFeePoolBalanceVo> getAmountByDate(SurplusFeePoolBalanceDto dto, String tenantCode) {
        if (StringUtil.isBlank((CharSequence)dto.getYearMonthStr()) || StringUtil.isBlank((CharSequence)dto.getBusinessFormatCode()) || StringUtil.isBlank((CharSequence)dto.getBusinessUnitCode()) || StringUtil.isBlank((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        return this.surplusFeePoolBalanceMapper.getAmountByDate(dto, tenantCode);
    }

    public List<SurplusFeePoolBalanceVo> findListForFR(List<SurplusFeePoolBalanceDto> balanceDtos, String code) {
        return this.surplusFeePoolBalanceMapper.findListForFR(balanceDtos, code, TenantUtils.getTenantCode());
    }
}

