/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRate;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateAsyncService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateLogService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateLogEventDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="DiscountRateAsyncService")
public class DiscountRateAsyncServiceImpl
implements DiscountRateAsyncService {
    private static final Logger log = LoggerFactory.getLogger(DiscountRateAsyncServiceImpl.class);
    @Autowired(required=false)
    private DiscountRateRepository discountRateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DiscountRateLogService discountRateLogService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddEdit(List<DiscountRateDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List rateList = Lists.partition(list, (int)500);
        for (List rates : rateList) {
            List oldList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DiscountRate::getOnlyKey, (Collection)rates.stream().map(DiscountRateDto::getOnlyKey).collect(Collectors.toList()))).list();
            Map<Object, Object> oldMap = new HashMap();
            List<DiscountRateDto> newList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)oldList)) {
                oldMap = oldList.stream().collect(Collectors.toMap(DiscountRate::getOnlyKey, Function.identity()));
                ArrayList<DiscountRateLogEventDto> editLogs = new ArrayList<DiscountRateLogEventDto>();
                for (DiscountRateDto dto : rates) {
                    if (!oldMap.containsKey(dto.getOnlyKey())) {
                        newList.add(dto);
                        continue;
                    }
                    DiscountRate old = (DiscountRate)((Object)oldMap.get(dto.getOnlyKey()));
                    DiscountRateLogEventDto eventDto = new DiscountRateLogEventDto();
                    DiscountRateVo rateVo = (DiscountRateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)old, DiscountRateVo.class, HashSet.class, ArrayList.class, new String[0]);
                    eventDto.setOriginal(rateVo);
                    old.setPlanRate(dto.getPlanRate());
                    old.setPlanRateStr(dto.getPlanRateStr());
                    old.setConfigCode(dto.getConfigCode());
                    old.setApproveTag(dto.getApproveTag());
                    old.setProcessStatus(dto.getProcessStatus());
                    DiscountRateDto dtoVo = (DiscountRateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)old, DiscountRateDto.class, HashSet.class, ArrayList.class, new String[0]);
                    eventDto.setNewest(dtoVo);
                    editLogs.add(eventDto);
                }
                this.discountRateRepository.updateBatchByIdAndTenantCode(oldMap.values(), TenantUtils.getTenantCode());
                this.discountRateLogService.updateLogAsync(editLogs);
            } else {
                newList = rates;
            }
            if (CollectionUtils.isEmpty(newList)) continue;
            List codes = this.generateCodeService.generateCode("DR", newList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
            for (int i = 0; i < newList.size(); ++i) {
                DiscountRateDto o = (DiscountRateDto)newList.get(i);
                o.setDiscountRateCode((String)codes.get(i));
            }
            Collection addList = this.nebulaToolkitService.copyCollectionByBlankList(newList, DiscountRateDto.class, DiscountRate.class, HashSet.class, ArrayList.class, new String[0]);
            this.discountRateRepository.saveBatch(addList);
            this.discountRateLogService.addLogAsync(newList);
        }
    }
}

