/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfigDimension;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateConfigDimensionRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateConfigDimensionService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDimensionDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDimensionPageDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateCustomerEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateCustomerProductEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateProductEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateRetailerRegionBrandEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateRetailerRegionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigDimensionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="discountRateConfigDimensionService")
public class DiscountRateConfigDimensionServiceImpl
implements DiscountRateConfigDimensionService {
    @Autowired(required=false)
    private DiscountRateConfigDimensionRepository discountRateConfigDimensionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatchDimension(List<DiscountRateConfigDimensionDto> dimensionList, String configCode, String tenantCode) {
        if (CollectionUtils.isEmpty(dimensionList)) {
            return;
        }
        Collection list = this.nebulaToolkitService.copyCollectionByBlankList(dimensionList, DiscountRateConfigDimensionDto.class, DiscountRateConfigDimension.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(item -> {
            item.setConfigCode(configCode);
            item.setTenantCode(tenantCode);
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        this.discountRateConfigDimensionRepository.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editBatchDimension(List<DiscountRateConfigDimensionDto> dimensionList, String configCode, String tenantCode) {
        Collection dimensions;
        if (CollectionUtils.isEmpty(dimensionList)) {
            return;
        }
        ArrayList<DiscountRateConfigDimensionDto> newList = new ArrayList<DiscountRateConfigDimensionDto>();
        ArrayList<DiscountRateConfigDimensionDto> oldList = new ArrayList<DiscountRateConfigDimensionDto>();
        ArrayList<String> ids = new ArrayList<String>();
        for (DiscountRateConfigDimensionDto dto : dimensionList) {
            if (StringUtil.isNotBlank((CharSequence)dto.getId())) {
                ids.add(dto.getId());
                oldList.add(dto);
                continue;
            }
            dto.setConfigCode(configCode);
            dto.setTenantCode(tenantCode);
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setId(null);
            newList.add(dto);
        }
        if (!CollectionUtils.isEmpty(ids)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.discountRateConfigDimensionRepository.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(DiscountRateConfigDimension::getConfigCode, (Object)configCode)).notIn(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        } else {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.discountRateConfigDimensionRepository.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(DiscountRateConfigDimension::getConfigCode, (Object)configCode)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        }
        if (!CollectionUtils.isEmpty(oldList)) {
            dimensions = this.nebulaToolkitService.copyCollectionByBlankList(oldList, DiscountRateConfigDimensionDto.class, DiscountRateConfigDimension.class, HashSet.class, ArrayList.class, new String[0]);
            this.discountRateConfigDimensionRepository.updateBatchByIdAndTenantCode(dimensions, tenantCode);
        }
        if (!CollectionUtils.isEmpty(newList)) {
            dimensions = this.nebulaToolkitService.copyCollectionByBlankList(newList, DiscountRateConfigDimensionDto.class, DiscountRateConfigDimension.class, HashSet.class, ArrayList.class, new String[0]);
            this.discountRateConfigDimensionRepository.saveBatch(dimensions);
        }
    }

    @Override
    public Page<DiscountRateConfigDimensionVo> findDimension(Pageable pageable, DiscountRateConfigDimensionPageDto pageDto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        Validate.notNull((Object)pageDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)pageDto.getDimensionType(), (String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList allList = new ArrayList();
        Map<String, String> fieldingMap = new HashMap(8);
        if (DiscountRateDimensionEnum.CUSTOMER.getCode().equals(pageDto.getDimensionType())) {
            fieldingMap = DiscountRateCustomerEnum.concertEnumToMap();
        } else if (DiscountRateDimensionEnum.CUSTOMER_PRODUCT.getCode().equals(pageDto.getDimensionType())) {
            fieldingMap = DiscountRateCustomerProductEnum.concertEnumToMap();
        } else if (DiscountRateDimensionEnum.PRODUCT.getCode().equals(pageDto.getDimensionType())) {
            fieldingMap = DiscountRateProductEnum.concertEnumToMap();
        } else if (DiscountRateDimensionEnum.RETAILER_REGION_BRAND.getCode().equals(pageDto.getDimensionType())) {
            fieldingMap = DiscountRateRetailerRegionBrandEnum.concertEnumToMap();
        } else if (DiscountRateDimensionEnum.RETAILER_REGION.getCode().equals(pageDto.getDimensionType())) {
            fieldingMap = DiscountRateRetailerRegionEnum.concertEnumToMap();
        }
        fieldingMap.forEach((code, name) -> {
            DiscountRateConfigDimensionVo dimensionVo = new DiscountRateConfigDimensionVo();
            dimensionVo.setFieldCode(code);
            dimensionVo.setFieldName(name);
            allList.add(dimensionVo);
        });
        List pageList = allList.stream().skip((long)(pageable.getPageNumber() - 1) * (long)pageable.getPageSize()).limit(pageable.getPageSize()).collect(Collectors.toList());
        Page page = new Page();
        page.setRecords(pageList);
        page.setSize((long)allList.size());
        page.setTotal((long)allList.size());
        return page;
    }
}

