/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfigDimension;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateConfigDimensionRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateConfigRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateAsyncService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateConfigDimensionService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateConfigService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigLogEventDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.event.log.DiscountRateConfigEventListener;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigDimensionVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigFormulaVariableVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="discountRateConfigService")
public class DiscountRateConfigServiceImpl
implements DiscountRateConfigService {
    @Autowired(required=false)
    private DiscountRateConfigRepository discountRateConfigRepository;
    @Autowired(required=false)
    private DiscountRateConfigDimensionRepository discountRateConfigDimensionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private DiscountRateConfigDimensionService discountRateConfigDimensionService;
    @Autowired(required=false)
    private DiscountRateAsyncService discountRateAsyncService;
    @Autowired(required=false)
    private List<FormulaVariableRegister> formulaVariableRegisterList;

    @Override
    public DiscountRateConfigVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DiscountRateConfig config = (DiscountRateConfig)((Object)this.discountRateConfigRepository.getById((Serializable)((Object)id)));
        if (null == config) {
            return null;
        }
        DiscountRateConfigVo configVo = (DiscountRateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)config, DiscountRateConfigVo.class, null, null, new String[0]);
        if (StringUtils.isBlank((CharSequence)configVo.getConfigCode())) {
            return configVo;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigDimensionRepository.lambdaQuery().eq(DiscountRateConfigDimension::getConfigCode, (Object)configVo.getConfigCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByAsc(DiscountRateConfigDimension::getSort)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return configVo;
        }
        Collection dimensionVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, DiscountRateConfigDimension.class, DiscountRateConfigDimensionVo.class, HashSet.class, ArrayList.class, new String[0]);
        configVo.setDimensionList((List)dimensionVos);
        return configVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(DiscountRateConfigDto configDto) {
        this.createValidate(configDto);
        int count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(DiscountRateConfig::getOnlyKey, (Object)configDto.getOnlyKey())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).count();
        Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6298\u6263\u7387\u914d\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", (Object[])new Object[0]);
        String code = (String)this.generateCodeService.generateCode("DRC", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        configDto.setConfigCode(code);
        configDto.setTenantCode(TenantUtils.getTenantCode());
        configDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        configDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        DiscountRateConfig config = (DiscountRateConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)configDto, DiscountRateConfig.class, null, null, new String[0]));
        this.discountRateConfigRepository.save((Object)config);
        this.discountRateConfigDimensionService.saveBatchDimension(configDto.getDimensionList(), configDto.getConfigCode(), configDto.getTenantCode());
        DiscountRateConfigLogEventDto logEventDto = new DiscountRateConfigLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(configDto);
        SerializableBiConsumer & Serializable onCreate = DiscountRateConfigEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DiscountRateConfigEventListener.class, (SerializableBiConsumer)onCreate);
    }

    private void createValidate(DiscountRateConfigDto configDto) {
        Validate.notNull((Object)configDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        configDto.setId(null);
        Validate.notBlank((CharSequence)configDto.getBusinessFormatCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getBusinessUnitCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((BusinessUnitEnum.VERTICAL.getCode().equals(configDto.getBusinessUnitCode()) || BusinessUnitEnum.isDefaultBusinessUnit((String)configDto.getBusinessUnitCode()) ? 1 : 0) != 0, (String)"\u6298\u6263\u7387\u914d\u7f6e\u76ee\u524d\u53ea\u652f\u6301\u4e3b\u4f53\u548c\u5782\u76f4\u91cd\u5ba2", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getRateVersion(), (String)"\u65b0\u589e\u65f6\uff0c\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getDimensionType(), (String)"\u65b0\u589e\u65f6\uff0c\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getApproveTag(), (String)"\u65b0\u589e\u65f6\uff0c\u662f\u5426\u5ba1\u6279\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(configDto.getBusinessUnitCode())) {
            Validate.notBlank((CharSequence)configDto.getBusinessDepartment(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u52a1\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)configDto.getBusinessUnitCode())) {
            Validate.notBlank((CharSequence)configDto.getSystemRateFormula(), (String)"\u65b0\u589e\u65f6\uff0c\u7cfb\u7edf\u6298\u6263\u7387\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)configDto.getSystemRateFormulaName(), (String)"\u65b0\u589e\u65f6\uff0c\u7cfb\u7edf\u6298\u6263\u7387\u8ba1\u7b97\u516c\u5f0f\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)configDto.getPlanRateFormula(), (String)"\u65b0\u589e\u65f6\uff0c\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getPlanRateFormulaName(), (String)"\u65b0\u589e\u65f6\uff0c\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387\u8ba1\u7b97\u516c\u5f0f\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String builder = configDto.getBusinessFormatCode() + configDto.getBusinessUnitCode() + configDto.getRateVersion();
        if (StringUtils.isNotBlank((CharSequence)configDto.getBusinessDepartment())) {
            builder = builder + configDto.getBusinessDepartment();
        }
        builder = builder + configDto.getDimensionType();
        configDto.setOnlyKey(builder);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(DiscountRateConfigDto configDto) {
        this.updateValidate(configDto);
        int count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(DiscountRateConfig::getOnlyKey, (Object)configDto.getOnlyKey())).ne(UuidEntity::getId, (Object)configDto.getId())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).count();
        Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6298\u6263\u7387\u914d\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", (Object[])new Object[0]);
        DiscountRateConfigVo oldVo = this.findById(configDto.getId());
        DiscountRateConfig config = (DiscountRateConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)configDto, DiscountRateConfig.class, null, null, new String[0]));
        String tenantCode = TenantUtils.getTenantCode();
        this.discountRateConfigRepository.updateByIdAndTenantCode(config, tenantCode);
        this.discountRateConfigDimensionService.editBatchDimension(configDto.getDimensionList(), oldVo.getConfigCode(), tenantCode);
        DiscountRateConfigLogEventDto logEventDto = new DiscountRateConfigLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(configDto);
        SerializableBiConsumer & Serializable onUpdate = DiscountRateConfigEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DiscountRateConfigEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    private void updateValidate(DiscountRateConfigDto configDto) {
        Validate.notNull((Object)configDto, (String)"\u7f16\u8f91\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getBusinessFormatCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getBusinessUnitCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getRateVersion(), (String)"\u7f16\u8f91\u65f6\uff0c\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getDimensionType(), (String)"\u7f16\u8f91\u65f6\uff0c\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getApproveTag(), (String)"\u7f16\u8f91\u65f6\uff0c\u662f\u5426\u5ba1\u6279\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(configDto.getBusinessUnitCode())) {
            Validate.notBlank((CharSequence)configDto.getBusinessDepartment(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e1a\u52a1\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)configDto.getBusinessUnitCode())) {
            Validate.notBlank((CharSequence)configDto.getSystemRateFormula(), (String)"\u7f16\u8f91\u65f6\uff0c\u7cfb\u7edf\u6298\u6263\u7387\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)configDto.getSystemRateFormulaName(), (String)"\u7f16\u8f91\u65f6\uff0c\u7cfb\u7edf\u6298\u6263\u7387\u8ba1\u7b97\u516c\u5f0f\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)configDto.getPlanRateFormula(), (String)"\u7f16\u8f91\u65f6\uff0c\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getPlanRateFormulaName(), (String)"\u7f16\u8f91\u65f6\uff0c\u8ba1\u5212/\u4fee\u6b63\u6298\u6263\u7387\u8ba1\u7b97\u516c\u5f0f\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String builder = configDto.getBusinessFormatCode() + configDto.getBusinessUnitCode() + configDto.getRateVersion();
        if (StringUtils.isNotBlank((CharSequence)configDto.getBusinessDepartment())) {
            builder = builder + configDto.getBusinessDepartment();
        }
        builder = builder + configDto.getDimensionType();
        configDto.setOnlyKey(builder);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List configList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)configList)) {
            return;
        }
        ArrayList<DiscountRateConfig> configs = new ArrayList<DiscountRateConfig>();
        configList.forEach(item -> {
            DiscountRateConfig config = new DiscountRateConfig();
            config.setId(item.getId());
            config.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            configs.add(config);
            DiscountRateConfigLogEventDto logEventDto = new DiscountRateConfigLogEventDto();
            DiscountRateConfigVo oldVo = (DiscountRateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateConfigVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            DiscountRateConfigDto newDto = (DiscountRateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateConfigDto.class, null, null, new String[0]);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDelete = DiscountRateConfigEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DiscountRateConfigEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.discountRateConfigRepository.updateBatchByIdAndTenantCode(configs, tenantCode);
    }

    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List configList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)configList)) {
            return;
        }
        ArrayList<DiscountRateConfig> configs = new ArrayList<DiscountRateConfig>();
        configList.forEach(item -> {
            DiscountRateConfig config = new DiscountRateConfig();
            config.setId(item.getId());
            config.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            configs.add(config);
            DiscountRateConfigLogEventDto logEventDto = new DiscountRateConfigLogEventDto();
            DiscountRateConfigVo oldVo = (DiscountRateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateConfigVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            DiscountRateConfigDto newDto = (DiscountRateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateConfigDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onEnable = DiscountRateConfigEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DiscountRateConfigEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.discountRateConfigRepository.updateBatchByIdAndTenantCode(configs, tenantCode);
    }

    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List configList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)configList)) {
            return;
        }
        ArrayList<DiscountRateConfig> configs = new ArrayList<DiscountRateConfig>();
        configList.forEach(item -> {
            DiscountRateConfig config = new DiscountRateConfig();
            config.setId(item.getId());
            config.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            configs.add(config);
            DiscountRateConfigLogEventDto logEventDto = new DiscountRateConfigLogEventDto();
            DiscountRateConfigVo oldVo = (DiscountRateConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateConfigVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            DiscountRateConfigDto newDto = (DiscountRateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateConfigDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDisable = DiscountRateConfigEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DiscountRateConfigEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.discountRateConfigRepository.updateBatchByIdAndTenantCode(configs, tenantCode);
    }

    @Override
    public List<DiscountRateConfigFormulaVariableVo> getFormulaVariable(String businessUnitCode) {
        Validate.notBlank((CharSequence)businessUnitCode, (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList voList = new ArrayList();
        if (!CollectionUtils.isEmpty(this.formulaVariableRegisterList)) {
            this.formulaVariableRegisterList.forEach(register -> {
                if (businessUnitCode.equals(register.getType())) {
                    DiscountRateConfigFormulaVariableVo vo = new DiscountRateConfigFormulaVariableVo();
                    vo.setCode(register.getVariableCode());
                    vo.setName(register.getVariableName());
                    vo.setSort(register.getSort());
                    voList.add(vo);
                }
            });
        }
        if (!CollectionUtils.isEmpty(voList)) {
            return voList.stream().sorted(Comparator.comparing(DiscountRateConfigFormulaVariableVo::getSort)).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public Map<String, DiscountRateConfig> getConfigByOnlyKeys(List<String> onlyKeys) {
        HashMap<String, DiscountRateConfig> map = new HashMap<String, DiscountRateConfig>();
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return map;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DiscountRateConfig::getOnlyKey, onlyKeys)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return map;
        }
        return list.stream().collect(Collectors.toMap(DiscountRateConfig::getOnlyKey, Function.identity()));
    }
}

