/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.aliyun.tea.utils.Validate;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRate;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateRepository;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateBudgetDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRatePlanCalDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateVersionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateBudgetVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DiscountRateSdkService")
public class DiscountRateSdkServiceImpl
implements DiscountRateSdkService {
    @Autowired(required=false)
    private DiscountRateRepository discountRateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<DiscountRateVo> findByConditions(Pageable pageable, DiscountRateDto rateDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(rateDto)) {
            rateDto = new DiscountRateDto();
        }
        rateDto.setTenantCode(TenantUtils.getTenantCode());
        return this.discountRateRepository.findByConditions(pageable, rateDto);
    }

    public Map<String, DiscountRateBudgetVo> getDiscountRateByDimensionCode(List<DiscountRateBudgetDto> budgetDtoList) {
        String version = DiscountRateVersionEnum.PLAN.getCode();
        String dimension = DiscountRateDimensionEnum.RETAILER_REGION.getCode();
        HashMap<String, DiscountRateBudgetVo> map = new HashMap<String, DiscountRateBudgetVo>();
        if (CollectionUtils.isEmpty(budgetDtoList)) {
            return map;
        }
        ArrayList<String> onlykeys = new ArrayList<String>();
        for (DiscountRateBudgetDto dto : budgetDtoList) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getMonthBudgetCode()), (String)"\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getYearAndMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String dateStr = DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)dto.getYearAndMonth());
            Validate.isTrue((boolean)BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u5fc5\u987b\u4e3a\u5782\u76f4", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCustomerRetailerCode()), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBrandCode()), (String)"\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getRegionCode()), (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String onlykey = dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + version + dimension + dateStr + dto.getCustomerRetailerCode() + dto.getRegionCode();
            onlykeys.add(onlykey);
        }
        List rateList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DiscountRate::getOnlyKey, onlykeys)).list();
        if (CollectionUtils.isEmpty((Collection)rateList)) {
            return map;
        }
        Map rateMap = rateList.stream().collect(Collectors.toMap(DiscountRate::getOnlyKey, Function.identity()));
        for (DiscountRateBudgetDto budgetDto : budgetDtoList) {
            String dateStr = DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)budgetDto.getYearAndMonth());
            String onlykey = budgetDto.getBusinessFormatCode() + budgetDto.getBusinessUnitCode() + version + dimension + dateStr + budgetDto.getCustomerRetailerCode() + budgetDto.getRegionCode();
            if (!rateMap.containsKey(onlykey)) continue;
            DiscountRate rate = (DiscountRate)((Object)rateMap.get(onlykey));
            DiscountRateBudgetVo budgetVo = (DiscountRateBudgetVo)this.nebulaToolkitService.copyObjectByBlankList((Object)rate, DiscountRateBudgetVo.class, null, null, new String[0]);
            map.put(budgetDto.getMonthBudgetCode(), budgetVo);
        }
        return map;
    }

    public List<DiscountRateDto> getDiscountRateByKeys(List<List<String>> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Lists.newArrayList();
        }
        return this.discountRateRepository.getDiscountRateByKeys(keys, TenantUtils.getTenantCode());
    }

    public List<DiscountRateDto> getDiscountRateByKeysNoPro(List<List<String>> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Lists.newArrayList();
        }
        return this.discountRateRepository.getDiscountRateByKeysNoPro(keys, TenantUtils.getTenantCode());
    }

    public Map<String, DiscountRateBudgetVo> getDiscountRateByOnlyKey(List<String> onlyKeyList) {
        HashMap<String, DiscountRateBudgetVo> map = new HashMap<String, DiscountRateBudgetVo>();
        if (CollectionUtils.isEmpty(onlyKeyList)) {
            return map;
        }
        List rateList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DiscountRate::getOnlyKey, onlyKeyList)).list();
        if (CollectionUtils.isEmpty((Collection)rateList)) {
            return map;
        }
        List discountRateBudgetVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)rateList, DiscountRate.class, DiscountRateBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return discountRateBudgetVos.stream().collect(Collectors.toMap(DiscountRateBudgetVo::getOnlyKey, Function.identity(), (oldVo, newVo) -> newVo));
    }

    public List<DiscountRateDto> findRateByPlanConditions(DiscountRatePlanCalDto calDto) {
        return this.discountRateRepository.findRateByPlanConditions(calDto);
    }
}

