/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRate;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateConfigRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateAsyncService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateLogService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateService;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateVariableService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateLogEventDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateProcessDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateRecalDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.event.log.DiscountRateEventListener;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateConfigSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="discountRateService")
public class DiscountRateServiceImpl
implements DiscountRateService {
    private static final Logger log = LoggerFactory.getLogger(DiscountRateServiceImpl.class);
    @Autowired(required=false)
    private DiscountRateRepository discountRateRepository;
    @Autowired(required=false)
    private DiscountRateConfigRepository discountRateConfigRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private DiscountRateVariableService discountRateVariableService;
    @Autowired(required=false)
    private DiscountRateLogService discountRateLogService;
    @Autowired(required=false)
    private DiscountRateConfigSdkService discountRateConfigSdkService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private DiscountRateAsyncService discountRateAsyncService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    @Override
    public DiscountRateVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DiscountRate rate = (DiscountRate)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
        if (null == rate) {
            return null;
        }
        return (DiscountRateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)rate, DiscountRateVo.class, null, null, new String[0]);
    }

    @Override
    public void update(DiscountRateDto rateDto) {
    }

    @Override
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List rateList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)rateList)) {
            return;
        }
        ArrayList<DiscountRate> rates = new ArrayList<DiscountRate>();
        rateList.forEach(item -> {
            DiscountRate rate = new DiscountRate();
            rate.setId(item.getId());
            rate.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            rates.add(rate);
            DiscountRateLogEventDto logEventDto = new DiscountRateLogEventDto();
            DiscountRateVo oldVo = (DiscountRateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            DiscountRateDto newDto = (DiscountRateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateDto.class, null, null, new String[0]);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDelete = DiscountRateEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DiscountRateEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.discountRateRepository.updateBatchByIdAndTenantCode(rates, tenantCode);
    }

    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List rateList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)rateList)) {
            return;
        }
        ArrayList<DiscountRate> rates = new ArrayList<DiscountRate>();
        rateList.forEach(item -> {
            DiscountRate rate = new DiscountRate();
            rate.setId(item.getId());
            rate.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            rates.add(rate);
            DiscountRateLogEventDto logEventDto = new DiscountRateLogEventDto();
            DiscountRateVo oldVo = (DiscountRateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            DiscountRateDto newDto = (DiscountRateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onEnable = DiscountRateEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DiscountRateEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.discountRateRepository.updateBatchByIdAndTenantCode(rates, tenantCode);
    }

    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List rateList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)rateList)) {
            return;
        }
        ArrayList<DiscountRate> rates = new ArrayList<DiscountRate>();
        rateList.forEach(item -> {
            DiscountRate rate = new DiscountRate();
            rate.setId(item.getId());
            rate.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            rates.add(rate);
            DiscountRateLogEventDto logEventDto = new DiscountRateLogEventDto();
            DiscountRateVo oldVo = (DiscountRateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            DiscountRateDto newDto = (DiscountRateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DiscountRateDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onEnable = DiscountRateEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DiscountRateEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.discountRateRepository.updateBatchByIdAndTenantCode(rates, tenantCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bulkImportSave(List<DiscountRateDto> importList) {
        try {
            if (CollectionUtils.isEmpty(importList)) {
                return;
            }
            AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
            Date date = new Date();
            ArrayList<DiscountRateDto> addList = new ArrayList<DiscountRateDto>();
            ArrayList<DiscountRateDto> editList = new ArrayList<DiscountRateDto>();
            for (DiscountRateDto dto : importList) {
                if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
                    dto.setModifyAccount(loginDetails.getUsername());
                    dto.setModifyName(loginDetails.getRealName());
                    dto.setModifyTime(date);
                    editList.add(dto);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)dto.getApproveTag())) {
                    dto.setApproveTag(YesOrNoEnum.NO.getCode());
                }
                dto.setCreateAccount(loginDetails.getUsername());
                dto.setCreateName(loginDetails.getRealName());
                dto.setCreateTime(date);
                dto.setTenantCode(loginDetails.getTenantCode());
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                addList.add(dto);
            }
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u65b0\u589e\u6570\u636e\u6761\u6570\uff1a{}", (Object)editList.size());
                List codes = this.generateCodeService.generateCode("DR", addList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
                for (int i = 0; i < addList.size(); ++i) {
                    DiscountRateDto rateDto = (DiscountRateDto)addList.get(i);
                    rateDto.setDiscountRateCode((String)codes.get(i));
                }
                Collection adds = this.nebulaToolkitService.copyCollectionByWhiteList(addList, DiscountRateDto.class, DiscountRate.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                List rateList = (List)adds;
                List rates = Lists.partition((List)rateList, (int)500);
                for (List list : rates) {
                    this.discountRateRepository.bulkSave(list);
                }
            }
            ArrayList<DiscountRateLogEventDto> editLogs = new ArrayList<DiscountRateLogEventDto>();
            if (!CollectionUtils.isEmpty(editList)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u7f16\u8f91\u6570\u636e\u6761\u6570\uff1a{}", (Object)editList.size());
                List rates = Lists.partition(editList, (int)500);
                for (List list : rates) {
                    List ids = list.stream().map(UuidDto::getId).collect(Collectors.toList());
                    List oldList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
                    Collection oldDtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)oldList, DiscountRate.class, DiscountRateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    Map oldMap = oldDtoList.stream().collect(Collectors.toMap(UuidVo::getId, Function.identity()));
                    for (DiscountRateDto dto : list) {
                        DiscountRateLogEventDto eventDto = new DiscountRateLogEventDto();
                        eventDto.setNewest(dto);
                        eventDto.setOriginal(oldMap.getOrDefault(dto.getId(), new DiscountRateVo()));
                        editLogs.add(eventDto);
                    }
                    Collection res = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, DiscountRateDto.class, DiscountRate.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    this.discountRateRepository.updateBatchByIdAndTenantCode(res, TenantUtils.getTenantCode());
                }
            }
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u65b0\u589e\u65e5\u5fd7");
                this.discountRateLogService.addLogAsync(addList);
            }
            if (!CollectionUtils.isEmpty(editLogs)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u7f16\u8f91\u65e5\u5fd7");
                this.discountRateLogService.updateLogAsync(editLogs);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new NullPointerException(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(DiscountRateProcessDto processDto) {
        Validate.isTrue((boolean)Objects.nonNull(processDto.getProcessBusiness()), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DiscountRate rate = (DiscountRate)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateRepository.lambdaQuery().eq(UuidEntity::getId, (Object)processDto.getId())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        Validate.notNull((Object)((Object)rate), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6298\u6263\u7387", (Object[])new Object[0]);
        DiscountRateConfig config = (DiscountRateConfig)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(DiscountRateConfig::getConfigCode, (Object)rate.getConfigCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        Validate.notNull((Object)((Object)config), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6298\u6263\u7387\u914d\u7f6e", (Object[])new Object[0]);
        Validate.isTrue((boolean)BooleanEnum.TRUE.getCapital().equals(config.getApproveTag()), (String)"\u6b64\u6298\u6263\u7387\u65e0\u9700\u5ba1\u6279", (Object[])new Object[0]);
        DiscountRateDto rateDto = (DiscountRateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)rate, DiscountRateDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.submitApprovalHandle(rateDto, processDto.getProcessBusiness());
    }

    public void submitApprovalHandle(DiscountRateDto dto, ProcessBusinessDto processBusiness) {
        processBusiness.setBusinessNo(dto.getDiscountRateCode());
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("discount_rate_process");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        DiscountRate entity = new DiscountRate();
        entity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        entity.setProcessNo(processBusinessVo.getProcessNo());
        entity.setId(dto.getId());
        this.discountRateRepository.updateByIdAndTenantCode(entity, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processPass(ProcessStatusDto dto) {
        this.discountRateRepository.updateProcessStatus(dto.getProcessNo(), dto.getProcessStatus());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processRejectAndRecover(ProcessStatusDto dto) {
        this.discountRateRepository.updateProcessStatus(dto.getProcessNo(), dto.getProcessStatus());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recal(DiscountRateRecalDto recalDto) {
        List list;
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)recalDto.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)recalDto.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)recalDto.getRateVersion()), (String)"\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)recalDto.getYearAndMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(DiscountRate::getYearAndMonth, (Object)recalDto.getYearAndMonth())).eq(DiscountRate::getBusinessFormatCode, (Object)recalDto.getBusinessFormatCode())).eq(DiscountRate::getBusinessUnitCode, (Object)recalDto.getBusinessUnitCode())).eq(DiscountRate::getRateVersion, (Object)recalDto.getRateVersion());
        if (StringUtils.isNotBlank((CharSequence)recalDto.getCustomerCode())) {
            wrapper.eq(DiscountRate::getCustomerCode, (Object)recalDto.getCustomerCode());
        }
        if (StringUtils.isNotBlank((CharSequence)recalDto.getRegionCode())) {
            wrapper.eq(DiscountRate::getRegionCode, (Object)recalDto.getRegionCode());
        }
        if (StringUtils.isNotBlank((CharSequence)recalDto.getCustomerRetailerCode())) {
            wrapper.eq(DiscountRate::getCustomerRetailerCode, (Object)recalDto.getCustomerRetailerCode());
        }
        if (StringUtils.isNotBlank((CharSequence)recalDto.getBrandCode())) {
            wrapper.eq(DiscountRate::getBrandCode, (Object)recalDto.getBrandCode());
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.discountRateRepository.list((Wrapper)wrapper)))) {
            return;
        }
        Map<String, List<DiscountRate>> configKeyMap = list.stream().collect(Collectors.groupingBy(i -> {
            String key = i.getBusinessFormatCode() + i.getBusinessUnitCode() + i.getRateVersion();
            if (StringUtils.isNotBlank((CharSequence)i.getBusinessDepartment())) {
                key = key + i.getBusinessDepartment();
            }
            key = key + i.getDimensionType();
            return key;
        }));
        List configList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DiscountRateConfig::getOnlyKey, configKeyMap.keySet())).list();
        if (CollectionUtils.isEmpty((Collection)configList)) {
            return;
        }
        for (DiscountRateConfig config : configList) {
            List rateList = configKeyMap.getOrDefault(config.getOnlyKey(), null);
            if (CollectionUtils.isEmpty((Collection)rateList)) continue;
            ArrayList<String> cusCodes = new ArrayList<String>();
            ArrayList<String> proCodes = new ArrayList<String>();
            ArrayList<String> reCodes = new ArrayList<String>();
            ArrayList<String> regionCodes = new ArrayList<String>();
            for (DiscountRate rate : rateList) {
                if (StringUtils.isNotBlank((CharSequence)rate.getCustomerCode())) {
                    cusCodes.add(rate.getCustomerCode());
                }
                if (StringUtils.isNotBlank((CharSequence)rate.getProductCode())) {
                    proCodes.add(rate.getProductCode());
                }
                if (StringUtils.isNotBlank((CharSequence)rate.getCustomerRetailerCode())) {
                    reCodes.add(rate.getCustomerRetailerCode());
                }
                if (!StringUtils.isNotBlank((CharSequence)rate.getRegionCode())) continue;
                regionCodes.add(rate.getRegionCode());
            }
            CalculateDto calculateDto = new CalculateDto();
            calculateDto.setYearAndMonth(recalDto.getYearAndMonth());
            calculateDto.setDimensionType(config.getDimensionType());
            Map<String, BigDecimal> sysMap = null;
            Map<String, BigDecimal> planMap = null;
            if (DiscountRateDimensionEnum.CUSTOMER.getCode().equals(config.getDimensionType())) {
                calculateDto.setCustomerCodeList(cusCodes);
                calculateDto.setFormula(config.getSystemRateFormula());
                sysMap = this.discountRateVariableService.singleCalculateExpressionBatch(calculateDto);
                calculateDto.setFormula(config.getSystemRateFormula());
                planMap = this.discountRateVariableService.singleCalculateExpressionBatch(calculateDto);
            } else if (DiscountRateDimensionEnum.CUSTOMER_PRODUCT.getCode().equals(config.getDimensionType())) {
                calculateDto.setCustomerCodeList(cusCodes);
                calculateDto.setProductCodeList(proCodes);
                calculateDto.setFormula(config.getSystemRateFormula());
                sysMap = this.discountRateVariableService.singleCalculateExpressionBatch(calculateDto);
                calculateDto.setFormula(config.getSystemRateFormula());
                planMap = this.discountRateVariableService.singleCalculateExpressionBatch(calculateDto);
            } else if (DiscountRateDimensionEnum.PRODUCT.getCode().equals(config.getDimensionType())) {
                calculateDto.setProductCodeList(proCodes);
                calculateDto.setFormula(config.getSystemRateFormula());
                sysMap = this.discountRateVariableService.singleCalculateExpressionBatch(calculateDto);
                calculateDto.setFormula(config.getSystemRateFormula());
                planMap = this.discountRateVariableService.singleCalculateExpressionBatch(calculateDto);
            } else {
                if (!DiscountRateDimensionEnum.RETAILER_REGION.getCode().equals(config.getDimensionType())) continue;
                calculateDto.setCustomerRetailerCodeList(reCodes);
                calculateDto.setRegionCodeList(regionCodes);
                calculateDto.setFormula(config.getSystemRateFormula());
                planMap = this.discountRateVariableService.singleCalculateExpressionBatch(calculateDto);
            }
            this.updateDate(config, rateList, sysMap, planMap);
        }
    }

    @Override
    public void verticalDiscountRateCal(String yearMonth) {
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        DiscountRateConfigDto configDto = new DiscountRateConfigDto();
        configDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        configDto.setDimensionType(DiscountRateDimensionEnum.RETAILER_REGION.getCode());
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(DiscountRateConfig::getDimensionType, (Object)configDto.getDimensionType())).eq(DiscountRateConfig::getBusinessUnitCode, (Object)configDto.getBusinessUnitCode())).count();
        if (count == 0) {
            return;
        }
        Map sysMap = this.customerRetailerVoService.getAllRetailerCode();
        Map regionMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        int i = 1;
        Page page;
        while (!CollectionUtils.isEmpty((Collection)(page = this.discountRateConfigSdkService.findByConditions((Pageable)PageRequest.of((int)i, (int)50), configDto)).getRecords())) {
            for (DiscountRateConfigVo record : page.getRecords()) {
                CalculateDto calculateDto = new CalculateDto();
                calculateDto.setFormula(record.getPlanRateFormula());
                calculateDto.setAllTag(Boolean.valueOf(true));
                calculateDto.setBusinessUnitCode(record.getBusinessUnitCode());
                calculateDto.setBusinessFormatCode(record.getBusinessFormatCode());
                calculateDto.setYearAndMonth(DateUtil.getDateByFormat((String)yearMonth, (String)"yyyy-MM"));
                Map<String, BigDecimal> map = this.discountRateVariableService.singleCalculateExpressionBatch(calculateDto);
                if (map.isEmpty()) continue;
                ArrayList<DiscountRateDto> rateList = new ArrayList<DiscountRateDto>();
                for (String s : map.keySet()) {
                    String[] arr = s.split("-");
                    if (arr.length < 2) continue;
                    DiscountRateDto rate = new DiscountRateDto();
                    rate.setApproveTag(record.getApproveTag());
                    if (YesOrNoEnum.YES.getCode().equals(record.getApproveTag())) {
                        rate.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                    }
                    rate.setBusinessFormatCode(record.getBusinessFormatCode());
                    rate.setBusinessUnitCode(record.getBusinessUnitCode());
                    rate.setBusinessDepartment(record.getBusinessDepartment());
                    rate.setDimensionType(record.getDimensionType());
                    rate.setRateVersion(record.getRateVersion());
                    rate.setYearAndMonth(calculateDto.getYearAndMonth());
                    rate.setYearAndMonthStr(DateUtil.dateToStr((Date)calculateDto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM));
                    rate.setCustomerRetailerCode(arr[0]);
                    rate.setCustomerRetailerName((String)sysMap.getOrDefault(rate.getCustomerRetailerCode(), null));
                    rate.setRegionCode(arr[1]);
                    rate.setRegionName((String)regionMap.getOrDefault(rate.getRegionCode(), null));
                    rate.setPlanRate(map.getOrDefault(s, BigDecimal.ZERO).setScale(3, 4));
                    rate.setPlanRateStr(rate.getPlanRate().multiply(new BigDecimal(100)).toString() + '%');
                    rate.setConfigCode(configDto.getConfigCode());
                    rate.setTenantCode(TenantUtils.getTenantCode());
                    String onlyKey = rate.getBusinessFormatCode() + rate.getBusinessUnitCode() + rate.getRateVersion() + rate.getDimensionType() + yearMonth + rate.getCustomerRetailerCode() + rate.getRegionCode();
                    rate.setOnlyKey(onlyKey);
                    rateList.add(rate);
                }
                this.discountRateAsyncService.batchAddEdit(rateList);
            }
            ++i;
        }
        return;
    }

    @Override
    public Map<String, String> getIdByKeys(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Maps.newHashMap();
        }
        List keyList = Lists.partition(keys, (int)500);
        List<DiscountRate> rates = this.discountRateRepository.getIdByKeys(keyList, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(rates)) {
            return Maps.newHashMap();
        }
        return rates.stream().collect(Collectors.toMap(DiscountRate::getOnlyKey, UuidEntity::getId, (oldValue, newValue) -> newValue));
    }

    public void updateDate(DiscountRateConfig config, List<DiscountRate> rateList, Map<String, BigDecimal> sysMap, Map<String, BigDecimal> planMap) {
        if (!CollectionUtils.isEmpty(rateList)) {
            for (DiscountRate rate : rateList) {
                String key = null;
                if (DiscountRateDimensionEnum.CUSTOMER.getCode().equals(config.getDimensionType())) {
                    key = rate.getCustomerCode();
                } else if (DiscountRateDimensionEnum.CUSTOMER_PRODUCT.getCode().equals(config.getDimensionType())) {
                    key = rate.getCustomerCode() + rate.getProductCode();
                } else if (DiscountRateDimensionEnum.PRODUCT.getCode().equals(config.getDimensionType())) {
                    key = rate.getProductCode();
                } else if (DiscountRateDimensionEnum.RETAILER_REGION_BRAND.getCode().equals(config.getDimensionType())) {
                    key = rate.getCustomerRetailerCode() + rate.getBrandCode() + rate.getRegionCode();
                } else {
                    if (!DiscountRateDimensionEnum.RETAILER_REGION.getCode().equals(config.getDimensionType())) continue;
                    key = rate.getCustomerRetailerCode() + rate.getRegionCode();
                }
                if (null != sysMap) {
                    BigDecimal b = sysMap.getOrDefault(key, BigDecimal.ZERO);
                    rate.setSystemRate(b.multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
                    rate.setSystemRateStr(rate.getSystemRate().toString() + '%');
                }
                if (null == planMap) continue;
                BigDecimal c = planMap.getOrDefault(key, BigDecimal.ZERO);
                rate.setPlanRate(c.multiply(BigDecimal.valueOf(100L)).setScale(2, 4));
                rate.setPlanRateStr(rate.getPlanRate().toString() + '%');
            }
            this.discountRateRepository.updateBatchByIdAndTenantCode(rateList, TenantUtils.getTenantCode());
        }
    }
}

