/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.biz.crm.tpm.business.budget.discount.rate.local.service.DiscountRateVariableService;
import com.biz.crm.tpm.business.budget.discount.rate.local.variable.utils.DiscountRateVariableUtil;
import com.biz.crm.tpm.business.budget.discount.rate.local.variable.utils.MathUtil;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DiscountRateVariableService")
public class DiscountRateVariableServiceImpl
implements DiscountRateVariableService {
    private static final Logger log = LoggerFactory.getLogger(DiscountRateVariableServiceImpl.class);
    @Autowired(required=false)
    private List<FormulaVariableRegister> formulaVariableRegisterList;
    @Autowired(required=false)
    private DiscountRateVariableUtil discountRateVariableUtil;

    @Override
    public BigDecimal singleCalculateExpression(CalculateDto dto) {
        Validate.notNull((Object)dto, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getFormula(), (String)"\u672a\u67e5\u627e\u5230\u516c\u5f0f", (Object[])new Object[0]);
        Set<String> formulas = MathUtil.getFormulaReplace(dto.getFormula());
        HashMap<String, BigDecimal> variableValueMap = new HashMap<String, BigDecimal>();
        formulas.forEach(variableName -> {
            List list = this.formulaVariableRegisterList.stream().filter(register -> variableName.startsWith(register.getVariableCode())).collect(Collectors.toList());
            Validate.noNullElements(list, (String)"\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            FormulaVariableRegister formulaVariableRegister = (FormulaVariableRegister)list.get(0);
            BigDecimal b = formulaVariableRegister.calculateVariable(dto);
            if (Objects.isNull(b)) {
                b = BigDecimal.ZERO;
            }
            variableValueMap.put((String)variableName, b);
        });
        String expressValue = this.discountRateVariableUtil.replaceExpression(dto.getFormula(), formulas, variableValueMap);
        return MathUtil.computeFormula(expressValue);
    }

    @Override
    public Map<String, BigDecimal> singleCalculateExpressionBatch(CalculateDto dto) {
        Validate.notNull((Object)dto, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getFormula(), (String)"\u672a\u67e5\u627e\u5230\u516c\u5f0f", (Object[])new Object[0]);
        Set<String> formulas = MathUtil.getFormulaReplace(dto.getFormula());
        HashMap variableValueMap = new HashMap();
        formulas.forEach(variableName -> {
            List list = this.formulaVariableRegisterList.stream().filter(register -> variableName.equals(register.getVariableCode())).collect(Collectors.toList());
            Validate.noNullElements(list, (String)"\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            FormulaVariableRegister formulaVariableRegister = (FormulaVariableRegister)list.get(0);
            HashMap b = formulaVariableRegister.calculateVariableBatch(dto);
            if (Objects.isNull(b)) {
                b = new HashMap();
            }
            variableValueMap.put(variableName, b);
        });
        HashMap variableValueMap2 = new HashMap();
        for (String s : variableValueMap.keySet()) {
            Map varMap = (Map)variableValueMap.get(s);
            for (String s1 : varMap.keySet()) {
                if (variableValueMap2.containsKey(s1)) {
                    ((Map)variableValueMap2.get(s1)).put(s, varMap.get(s1));
                    continue;
                }
                HashMap newMap = new HashMap();
                newMap.put(s, varMap.get(s1));
                variableValueMap2.put(s1, newMap);
            }
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (String key : variableValueMap2.keySet()) {
            String expressValue = this.discountRateVariableUtil.replaceExpression(dto.getFormula(), formulas, (Map)variableValueMap2.get(key));
            BigDecimal b = BigDecimal.ZERO;
            try {
                b = MathUtil.computeFormula(expressValue);
            }
            catch (Exception e) {
                log.error("\u6298\u6263\u7387\u5b9a\u65f6\u4efb\u52a1\u8ba1\u7b97\u8868\u8fbe\u5f0f\u62a5\u9519\uff1a{},key = {}", (Object)e.getMessage(), (Object)key);
            }
            map.put(key, b);
        }
        return map;
    }
}

