/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.match.sdk.dto.SurplusFeePoolBalanceAuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditSapVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.SurplusFeePoolBalanceAuditMatchVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.DiscountRateConfig;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.SurplusFeePoolBalance;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.DiscountRateConfigRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.SurplusFeePoolBalanceRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolBalanceService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.DiscountRateConfigDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.enums.DiscountRateDimensionEnum;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.DiscountRateConfigSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.DiscountRateConfigVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.SurplusFeePoolBalanceAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.enums.AssociationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="surplusFeePoolBalanceService")
public class SurplusFeePoolBalanceServiceImpl
implements SurplusFeePoolBalanceService {
    private static final Logger log = LoggerFactory.getLogger(SurplusFeePoolBalanceServiceImpl.class);
    @Autowired(required=false)
    private SurplusFeePoolBalanceRepository surplusFeePoolBalanceRepository;
    @Autowired(required=false)
    private DiscountRateConfigSdkService discountRateConfigSdkService;
    @Autowired(required=false)
    private DiscountRateConfigRepository discountRateConfigRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private AuditSapVoService auditSapVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    @Override
    public Map<String, SurplusFeePoolBalanceVo> getPoolBalanceByOnlyKeys(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return Maps.newHashMap();
        }
        List keyList = Lists.partition(onlyKeys, (int)500);
        List<SurplusFeePoolBalanceVo> list = this.surplusFeePoolBalanceRepository.getPoolBalanceByOnlyKeys(keyList, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(SurplusFeePoolBalanceVo::getOnlyKey, Function.identity(), (oldValue, newValue) -> newValue));
    }

    @Override
    public Map<String, BigDecimal> getAmountByDate(SurplusFeePoolBalanceDto dto) {
        if (StringUtil.isBlank((CharSequence)dto.getYearMonthStr()) || StringUtil.isBlank((CharSequence)dto.getBusinessFormatCode()) || StringUtil.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return Maps.newHashMap();
        }
        List<SurplusFeePoolBalanceVo> list = this.surplusFeePoolBalanceRepository.getAmountByDate(dto, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(SurplusFeePoolBalanceVo::getOnlyKey, SurplusFeePoolBalanceVo::getBalance, (oldValue, newValue) -> newValue));
    }

    @Override
    public void verticalSurplusFeePoolBalanceCal(String yearMonth) {
        if (StringUtil.isBlank((CharSequence)yearMonth)) {
            return;
        }
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        DiscountRateConfigDto configDto = new DiscountRateConfigDto();
        configDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        configDto.setDimensionType(DiscountRateDimensionEnum.RETAILER_REGION.getCode());
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discountRateConfigRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(DiscountRateConfig::getDimensionType, (Object)configDto.getDimensionType())).eq(DiscountRateConfig::getBusinessUnitCode, (Object)configDto.getBusinessUnitCode())).count();
        if (count == 0) {
            return;
        }
        Map sysMap = this.customerRetailerVoService.getAllRetailerCode();
        Map regionMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        Date date = DateUtil.strToDate((String)yearMonth, (SimpleDateFormat)DateUtil.date_yyyy_MM);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        String lastYearMonthStr = DateUtil.dateToStr((Date)calendar.getTime(), (SimpleDateFormat)DateUtil.date_yyyy_MM);
        int i = 1;
        Page page;
        while (!CollectionUtils.isEmpty((Collection)(page = this.discountRateConfigSdkService.findByConditions((Pageable)PageRequest.of((int)i, (int)50), configDto)).getRecords())) {
            for (DiscountRateConfigVo record : page.getRecords()) {
                SurplusFeePoolBalanceDto balanceDto = new SurplusFeePoolBalanceDto();
                balanceDto.setBusinessFormatCode(record.getBusinessFormatCode());
                balanceDto.setBusinessUnitCode(record.getBusinessUnitCode());
                balanceDto.setYearMonthStr(lastYearMonthStr);
                Map<String, BigDecimal> periodMap = this.getAmountByDate(balanceDto);
                ActivityDetailPlanItemStatisticsDto dto = new ActivityDetailPlanItemStatisticsDto();
                dto.setBusinessFormatCode(record.getBusinessFormatCode());
                dto.setBusinessUnitCode(record.getBusinessUnitCode());
                dto.setFeeYearMonth(DateUtil.strToDate((String)lastYearMonthStr, (SimpleDateFormat)DateUtil.date_yyyy_MM));
                dto.setTenantCode(TenantUtils.getTenantCode());
                dto.setEndCaseForm(EndCaseFormEnum.DISCOUNT.getCode());
                Map accountMap = this.activityDetailPlanItemSdkService.statisDiscountAccountFee(dto);
                SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto = new SurplusFeePoolBalanceAssessedAmountStatisticsDto();
                assessDto.setBusinessFormatCode(record.getBusinessFormatCode());
                assessDto.setBusinessUnitCode(record.getBusinessUnitCode());
                assessDto.setFeeYearMonth(DateUtil.strToDate((String)lastYearMonthStr, (SimpleDateFormat)DateUtil.date_yyyy_MM));
                assessDto.setRelationType(AssociationTypeEnum.EXPENSE_POOL.getCode());
                Map assessMap = this.tpmExamineCircularService.statisAssessDeduction(assessDto);
                HashMap<String, BigDecimal> disMap = new HashMap<String, BigDecimal>();
                this.get105Discount(disMap, record.getBusinessUnitCode(), record.getBusinessFormatCode(), lastYearMonthStr);
                HashSet<String> splicingCodeSet = new HashSet<String>();
                if (!periodMap.isEmpty()) {
                    log.error("periodMap\u7684key[{}]", periodMap.keySet());
                    splicingCodeSet.addAll(periodMap.keySet());
                }
                if (!accountMap.isEmpty()) {
                    log.error("accountMap\u7684key[{}]", accountMap.keySet());
                    splicingCodeSet.addAll(accountMap.keySet());
                }
                if (!assessMap.isEmpty()) {
                    log.error("assessMap\u7684key[{}]", assessMap.keySet());
                    splicingCodeSet.addAll(assessMap.keySet());
                }
                if (!disMap.isEmpty()) {
                    log.error("disMap\u7684key[{}]", disMap.keySet());
                    splicingCodeSet.addAll(disMap.keySet());
                }
                ArrayList<SurplusFeePoolBalance> balanceList = new ArrayList<SurplusFeePoolBalance>();
                for (String s : splicingCodeSet) {
                    BigDecimal b = BigDecimal.ZERO;
                    b = b.add(periodMap.getOrDefault(s, BigDecimal.ZERO));
                    b = b.add(accountMap.getOrDefault(s, BigDecimal.ZERO));
                    b = b.add(assessMap.getOrDefault(s, BigDecimal.ZERO));
                    b = b.subtract(disMap.getOrDefault(s, BigDecimal.ZERO));
                    String[] arr = s.split("-");
                    if (arr.length < 2) continue;
                    SurplusFeePoolBalance balance = new SurplusFeePoolBalance();
                    balance.setBalance(b);
                    balance.setCustomerRetailerCode(arr[0]);
                    balance.setCustomerRetailerName(sysMap.getOrDefault(arr[0], null));
                    balance.setRegionCode(arr[1]);
                    balance.setRegionName(regionMap.getOrDefault(arr[1], null));
                    balance.setBusinessFormatCode(record.getBusinessFormatCode());
                    balance.setBusinessUnitCode(record.getBusinessUnitCode());
                    balance.setYearMonthStr(yearMonth);
                    balance.setOnlyKey(balance.getBusinessFormatCode() + "-" + balance.getBusinessUnitCode() + "-" + s + "-" + yearMonth.replaceAll("-", ""));
                    balance.setTenantCode(TenantUtils.getTenantCode());
                    balanceList.add(balance);
                }
                if (!CollectionUtils.isEmpty(balanceList)) {
                    Set onlyKeys = balanceList.stream().map(SurplusFeePoolBalance::getOnlyKey).collect(Collectors.toSet());
                    List oldBaList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.surplusFeePoolBalanceRepository.lambdaQuery().in(SurplusFeePoolBalance::getOnlyKey, onlyKeys)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
                    if (!CollectionUtils.isEmpty((Collection)oldBaList)) {
                        Map<String, String> oldBaMap = oldBaList.stream().collect(Collectors.toMap(SurplusFeePoolBalance::getOnlyKey, UuidEntity::getId));
                        for (SurplusFeePoolBalance balance : balanceList) {
                            if (!oldBaMap.containsKey(balance.getOnlyKey())) continue;
                            balance.setId(oldBaMap.getOrDefault(balance.getOnlyKey(), null));
                        }
                    }
                }
                this.surplusFeePoolBalanceRepository.saveOrUpdateBatch(balanceList);
            }
            ++i;
        }
        return;
    }

    @Override
    public void get105Discount(Map<String, BigDecimal> disMap, String businessUnitCode, String businessFormatCode, String yearMonth) {
        Page terPage;
        TerminalPaginationDto terDto = new TerminalPaginationDto();
        terDto.setTenantCode(TenantUtils.getTenantCode());
        terDto.setBusinessUnitCode(businessUnitCode);
        terDto.setBusinessFormatCode(businessFormatCode);
        int k = 1;
        while (!Objects.isNull(terPage = this.terminalVoService.findBaseByDto((Pageable)PageRequest.of((int)k, (int)2000), terDto)) && !CollectionUtils.isEmpty((Collection)terPage.getRecords())) {
            Map terMap = terPage.getRecords().stream().filter(item -> StringUtil.isNotBlank((CharSequence)item.getCustomerRetailerCode()) && StringUtil.isNotBlank((CharSequence)item.getRegionCode())).collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (outTer, newTer) -> newTer));
            SurplusFeePoolBalanceAuditMatchDto discountDto = new SurplusFeePoolBalanceAuditMatchDto();
            discountDto.setYearAndMonth(yearMonth.replaceAll("-", ""));
            List scCodes = Lists.partition(new ArrayList<String>(terMap.keySet()), (int)500);
            discountDto.setServiceCodeList(scCodes);
            List matchVoList = this.auditSapVoService.surplusFeePoolBalance(discountDto);
            if (CollectionUtils.isEmpty((Collection)matchVoList)) {
                ++k;
                continue;
            }
            Map<String, BigDecimal> matchMap = matchVoList.stream().collect(Collectors.toMap(SurplusFeePoolBalanceAuditMatchVo::getServiceCode, SurplusFeePoolBalanceAuditMatchVo::getDiscountAmount));
            for (String s : terMap.keySet()) {
                TerminalVo ter = (TerminalVo)terMap.get(s);
                String key1 = ter.getCustomerRetailerCode() + "-" + ter.getRegionCode();
                if (!matchMap.containsKey(s)) continue;
                BigDecimal b = matchMap.get(s);
                if (disMap.containsKey(key1)) {
                    BigDecimal dis = disMap.get(key1).add(b);
                    disMap.put(key1, dis);
                    continue;
                }
                disMap.put(key1, b);
            }
            ++k;
        }
    }
}

