/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.DiscountAccountFeeGroupVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.entity.SurplusFeePoolSoldBalance;
import com.biz.crm.tpm.business.budget.discount.rate.local.repository.SurplusFeePoolSoldBalanceRepository;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolSoldBalanceService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolSoldBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.SurplusFeePoolSoldBalanceSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolSoldBalanceVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.SurplusFeePoolBalanceAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.enums.AssociationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SurplusFeePoolSoldBalanceServiceImpl
implements SurplusFeePoolSoldBalanceService,
SurplusFeePoolSoldBalanceSdkService {
    private static final Logger log = LoggerFactory.getLogger(SurplusFeePoolSoldBalanceServiceImpl.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired
    private SurplusFeePoolSoldBalanceRepository surplusFeePoolSoldBalanceRepository;
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    private static final int pageSize = 2000;

    @Override
    @Transactional
    public void createSurplusFeePoolSoldBalance(ActivityDetailPlanItemStatisticsDto dto) {
        if (dto.getFeeYearMonth() == null) {
            log.error("\u83b7\u53d6\u5230\u5f53\u524d\u5e74\u6708\u4e3a\u7a7a");
            return;
        }
        dto.setFeeYearMonth((Date)DateUtil.offsetMonth((Date)dto.getFeeYearMonth(), (int)-1));
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEndCaseForm(EndCaseFormEnum.DISCOUNT.getCode());
        PageRequest pageable = PageRequest.of((int)1, (int)2000);
        Page<DiscountAccountFeeGroupVo> feeGroupVoPage = this.buildSurplusFeePoolSoldBalance(dto, (Pageable)pageable);
        long total = feeGroupVoPage.getTotal();
        if (total > 2000L) {
            long num = total / 2000L;
            if (total % 2000L > 0L) {
                ++num;
            }
            int i = 2;
            while ((long)i <= num) {
                pageable = PageRequest.of((int)i, (int)2000);
                this.buildSurplusFeePoolSoldBalance(dto, (Pageable)pageable);
                ++i;
            }
        }
    }

    private Page<DiscountAccountFeeGroupVo> buildSurplusFeePoolSoldBalance(ActivityDetailPlanItemStatisticsDto dto, Pageable pageable) {
        Page feeGroupVoPage = this.activityDetailPlanItemSdkService.findPageStatisDiscountAccountFee(dto, pageable);
        List records = feeGroupVoPage.getRecords();
        if (ObjectUtils.isNotEmpty((Object)records)) {
            Map regionMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
            ArrayList list = new ArrayList();
            records.stream().forEach(record -> {
                String onlyKey = StringUtils.joinWith((String)"-", (Object[])new Object[]{record.getBusinessFormatCode(), record.getBusinessUnitCode(), record.getSystemCode(), record.getRegionCode(), record.getSoldCode(), record.getYearMonthStr()});
                SurplusFeePoolSoldBalance soldBalance = this.surplusFeePoolSoldBalanceRepository.findSurplusFeePoolSoldBalance(onlyKey);
                if (soldBalance == null) {
                    soldBalance = new SurplusFeePoolSoldBalance();
                    BeanUtils.copyProperties((Object)record, (Object)((Object)soldBalance));
                    soldBalance.setOnlyKey(onlyKey);
                    soldBalance.setTenantCode(TenantUtils.getTenantCode());
                    soldBalance.setRegionName(regionMap.getOrDefault(record.getRegionCode(), null));
                }
                SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto = new SurplusFeePoolBalanceAssessedAmountStatisticsDto();
                assessDto.setBusinessFormatCode(record.getBusinessFormatCode());
                assessDto.setBusinessUnitCode(record.getBusinessUnitCode());
                assessDto.setFeeYearMonth(dto.getFeeYearMonth());
                assessDto.setRegionCode(record.getRegionCode());
                assessDto.setSystemCode(record.getSystemCode());
                assessDto.setSoldCode(record.getSoldCode());
                assessDto.setRelationType(AssociationTypeEnum.EXPENSE_POOL.getCode());
                assessDto.setTenantCode(TenantUtils.getTenantCode());
                BigDecimal examineMoney = this.tpmExamineCircularService.getExamineMoney(assessDto);
                BigDecimal sapMoney = BigDecimal.ZERO;
                String lastOnlyKey = StringUtils.joinWith((String)"-", (Object[])new Object[]{record.getBusinessFormatCode(), record.getBusinessUnitCode(), record.getSystemCode(), record.getRegionCode(), record.getSoldCode(), DateUtil.format((Date)DateUtil.offsetMonth((Date)dto.getFeeYearMonth(), (int)-1), (String)"yyyy-MM")});
                SurplusFeePoolSoldBalance lastSoldBalance = this.surplusFeePoolSoldBalanceRepository.findSurplusFeePoolSoldBalance(lastOnlyKey);
                BigDecimal lastMonthMoney = BigDecimal.ZERO;
                if (lastSoldBalance != null) {
                    lastMonthMoney = lastSoldBalance.getBalance();
                    soldBalance.setParentOnlyKey(lastSoldBalance.getOnlyKey());
                }
                soldBalance.setBalance(record.getBalance().add(examineMoney).add(sapMoney).add(lastMonthMoney));
                list.add(soldBalance);
            });
            if (ObjectUtils.isNotEmpty(list)) {
                this.surplusFeePoolSoldBalanceRepository.saveOrUpdateBatch(list);
            }
        }
        return feeGroupVoPage;
    }

    @Override
    @Transactional
    public void continueLastMonthSurplusFeePoolSoldeBalance() {
        SurplusFeePoolSoldBalanceDto dto = new SurplusFeePoolSoldBalanceDto();
        dto.setYearMonth((Date)DateUtil.offsetMonth((Date)DateUtil.date(), (int)-1));
        dto.setLastYearMonth((Date)DateUtil.offsetMonth((Date)DateUtil.date(), (int)-2));
        PageRequest pageable = PageRequest.of((int)1, (int)2000);
        Page<SurplusFeePoolSoldBalance> balancePage = this.buildNewSurplusFeePoolSoldeBalance(dto, (Pageable)pageable);
        long total = balancePage.getTotal();
        if (total > 2000L) {
            long num = total / 2000L;
            if (total % 2000L > 0L) {
                ++num;
            }
            int i = 2;
            while ((long)i <= num) {
                pageable = PageRequest.of((int)i, (int)2000);
                this.buildNewSurplusFeePoolSoldeBalance(dto, (Pageable)pageable);
                ++i;
            }
        }
    }

    private Page<SurplusFeePoolSoldBalance> buildNewSurplusFeePoolSoldeBalance(SurplusFeePoolSoldBalanceDto dto, Pageable pageable) {
        Page<SurplusFeePoolSoldBalance> balancePage = this.surplusFeePoolSoldBalanceRepository.continueLastMonthSurplusFeePoolSoldeBalance(pageable, dto);
        List records = balancePage.getRecords();
        if (ObjectUtils.isNotEmpty((Object)records)) {
            ArrayList list = new ArrayList();
            records.stream().forEach(record -> {
                SurplusFeePoolSoldBalance soldBalance = new SurplusFeePoolSoldBalance();
                BeanUtils.copyProperties((Object)record, (Object)((Object)soldBalance), (String[])new String[]{"id", "createTime", "modifyTime"});
                soldBalance.setYearMonthStr(DateUtil.format((Date)dto.getYearMonth(), (String)"yyyy-MM"));
                String onlyKey = StringUtils.joinWith((String)"-", (Object[])new Object[]{record.getBusinessFormatCode(), record.getBusinessUnitCode(), record.getSystemCode(), record.getRegionCode(), record.getSoldCode(), soldBalance.getYearMonthStr()});
                soldBalance.setOnlyKey(onlyKey);
                list.add(soldBalance);
            });
            if (ObjectUtils.isNotEmpty(list)) {
                this.surplusFeePoolSoldBalanceRepository.saveOrUpdateBatch(list);
            }
        }
        return balancePage;
    }

    public Page<SurplusFeePoolSoldBalanceVo> findByConditions(Pageable pageable, SurplusFeePoolSoldBalanceDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)2000));
        return this.surplusFeePoolSoldBalanceRepository.findByConditions(pageable, dto);
    }
}

