/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.variable.register;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDiscountSalesStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NextMonthDiscountAfterSalesVariableRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(NextMonthDiscountAfterSalesVariableRegister.class);
    @Autowired(required=false)
    private SalesGoalService salesGoalService;

    public String getVariableCode() {
        return "ZHXSE";
    }

    public String getVariableName() {
        return "\u6298\u540e\u9500\u552e\u989d";
    }

    public Integer getSort() {
        return 5;
    }

    public String getType() {
        return BusinessUnitEnum.VERTICAL.getCode();
    }

    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerRetailerCode(), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getRegionCode(), (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBrandCode(), (String)"\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return new BigDecimal(100);
    }

    public Map<String, BigDecimal> calculateVariableBatch(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)calculateDto.getBusinessFormatCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)calculateDto.getBusinessUnitCode())) {
            return new HashMap<String, BigDecimal>();
        }
        SalesGoalDiscountSalesStatisticsDto dto = new SalesGoalDiscountSalesStatisticsDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setYearMonth(DateUtil.dateToStr((Date)calculateDto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM));
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
        return this.salesGoalService.getSalesAfterDiscount(dto);
    }
}

