/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.discount.rate.local.variable.register;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.budget.discount.rate.local.service.SurplusFeePoolBalanceService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.SurplusFeePoolBalanceAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.enums.AssociationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SurplusFeePoolBalanceVariableRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(SurplusFeePoolBalanceVariableRegister.class);
    @Autowired(required=false)
    private SurplusFeePoolBalanceService surplusFeePoolBalanceService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;

    public String getVariableCode() {
        return "SYFYCYE";
    }

    public String getVariableName() {
        return "\u5269\u4f59\u8d39\u7528\u6c60\u4f59\u989d";
    }

    public Integer getSort() {
        return 3;
    }

    public String getType() {
        return BusinessUnitEnum.VERTICAL.getCode();
    }

    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return new BigDecimal(300);
    }

    public Map<String, BigDecimal> calculateVariableBatch(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)calculateDto.getBusinessFormatCode())) {
            return new HashMap<String, BigDecimal>();
        }
        if (StringUtils.isBlank((CharSequence)calculateDto.getBusinessUnitCode())) {
            return new HashMap<String, BigDecimal>();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(calculateDto.getYearAndMonth());
        calendar.add(2, -1);
        String lastYearMonthStr = DateUtil.dateToStr((Date)calendar.getTime(), (SimpleDateFormat)DateUtil.date_yyyy_MM);
        SurplusFeePoolBalanceDto balanceDto = new SurplusFeePoolBalanceDto();
        balanceDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        balanceDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        balanceDto.setYearMonthStr(lastYearMonthStr);
        Map<String, BigDecimal> periodMap = this.surplusFeePoolBalanceService.getAmountByDate(balanceDto);
        ActivityDetailPlanItemStatisticsDto dto = new ActivityDetailPlanItemStatisticsDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setFeeYearMonth(calendar.getTime());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEndCaseForm(EndCaseFormEnum.DISCOUNT.getCode());
        if (!calculateDto.getAllTag().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)calculateDto.getCustomerRetailerCodeList()) || CollectionUtils.isEmpty((Collection)calculateDto.getRegionCodeList())) {
                return new HashMap<String, BigDecimal>();
            }
            dto.setCustomerRetailerCodeList(calculateDto.getCustomerRetailerCodeList());
            dto.setRegionCodeList(calculateDto.getRegionCodeList());
        }
        Map accountMap = this.activityDetailPlanItemSdkService.statisDiscountAccountFee(dto);
        SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto = new SurplusFeePoolBalanceAssessedAmountStatisticsDto();
        assessDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        assessDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        assessDto.setFeeYearMonth(calendar.getTime());
        assessDto.setRelationType(AssociationTypeEnum.EXPENSE_POOL.getCode());
        Map assessMap = this.tpmExamineCircularService.statisAssessDeduction(assessDto);
        HashMap<String, BigDecimal> disMap = new HashMap<String, BigDecimal>();
        this.surplusFeePoolBalanceService.get105Discount(disMap, calculateDto.getBusinessUnitCode(), calculateDto.getBusinessFormatCode(), lastYearMonthStr);
        HashMap<String, BigDecimal> finallyMap = new HashMap<String, BigDecimal>();
        HashSet<String> splicingCodeSet = new HashSet<String>();
        if (!periodMap.isEmpty()) {
            log.error("periodMap\u7684key[{}]", periodMap.keySet());
            splicingCodeSet.addAll(periodMap.keySet());
        }
        if (!accountMap.isEmpty()) {
            log.error("accountMap\u7684key[{}]", accountMap.keySet());
            splicingCodeSet.addAll(accountMap.keySet());
        }
        if (!assessMap.isEmpty()) {
            log.error("assessMap\u7684key[{}]", assessMap.keySet());
            splicingCodeSet.addAll(assessMap.keySet());
        }
        if (!disMap.isEmpty()) {
            log.error("disMap\u7684key[{}]", disMap.keySet());
            splicingCodeSet.addAll(disMap.keySet());
        }
        for (String s : splicingCodeSet) {
            BigDecimal b = BigDecimal.ZERO;
            b = b.add(periodMap.getOrDefault(s, BigDecimal.ZERO));
            b = b.add(accountMap.getOrDefault(s, BigDecimal.ZERO));
            b = b.add(assessMap.getOrDefault(s, BigDecimal.ZERO));
            b = b.subtract(disMap.getOrDefault(s, BigDecimal.ZERO));
            finallyMap.put(s, b);
        }
        return finallyMap;
    }
}

