package com.biz.crm.tpm.business.budget.forecast.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.forecast.feign.feign.internal.BudgetForecastFeignImpl;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.BudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @author huojia
 * @date 2022年12月13日 10:25
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = BudgetForecastFeignImpl.class)
public interface BudgetForecastFeign {

    /**
     * 分页查询预算预测
     *
     * @param pageable
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastVo>>
     * @author huojia
     * @date 2022/12/13 10:30
     **/
    @GetMapping("/v1/budget/forecast/findByConditions")
    Result<Page<BudgetForecastVo>> findByConditions(Pageable pageable, BudgetForecastDto dto);
}
