package com.biz.crm.tpm.business.budget.forecast.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.budget.forecast.feign.feign.SubComBudgetForecastFeign;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.*;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.dto.ProfitGoalDiscountDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author huojia
 * @date 2022年12月13日 10:42
 */
@Slf4j
@Service
public class SubComBudgetForecastServiceImpl implements SubComBudgetForecastService {

    @Resource
    private SubComBudgetForecastFeign subComBudgetForecastFeign;

    @Override
    public Page<SubComBudgetForecastVo> findByConditions(Pageable pageable, SubComBudgetForecastDto dto) {
        Result<Page<SubComBudgetForecastVo>> result = subComBudgetForecastFeign.findByConditions(pageable, dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public void updateByConfigBatch(List<ProfitGoalDiscountDto> profitGoalDiscountDtoList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String saveByConfigBatch(List<ProfitGoalDiscountDto> profitGoalDiscountDtoList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initByCode(String budgetForecastCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void manualInternalData(String yearMonth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void calInternalData(String yearMonth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void calInternalDataLikeExternal(String yearMonth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void calExternalData(String yearMonth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SubComBudgetForecastVo> listByConditions(SubComBudgetForecastDto subComBudgetForecastDto) {
        Result<List<SubComBudgetForecastVo>> result = subComBudgetForecastFeign.listByConditions(subComBudgetForecastDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public void operationBudgetForecast(List<SubComBudgetForecastDetailDto> subComBudgetForecastDtoList) {
        Result result = subComBudgetForecastFeign.operationBudgetForecast(subComBudgetForecastDtoList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
    }

    @Override
    public BigDecimal queryTaxAndAddition(SubComBudgetForecastVo subComBudgetForecastVo) {
        Result<BigDecimal> result = subComBudgetForecastFeign.queryTaxAndAddition(subComBudgetForecastVo);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public void clearByCode(List<String> budgetForecastCodeList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateBudgetForecastForActivityPlan(List<ActivityPlanItemDto> activityPlanItemList) {

    }

    @Override
    public SubComBudgetForecastVo summationBudgetAmount(SubComBudgetForecastDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void importSave(List<SubComBudgetForecastDto> importList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SubComBudgetForecastVo> findListByBudgetItemCodes(List<String> codes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeUndertakeAmt(SubComBudgetForecastDto dto, BigDecimal wholeUndertakeAmt,BigDecimal partUndertakeAmt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SubComBudgetForecastVo findById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void adjust(SubComBudgetForecastAdjustDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String adjustSubmit(SubComBudgetForecastAdjustDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unOrFreeze(SubComBudgetForecastOperateDto dto, String operationType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void change(SubComBudgetForecastOperateDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String changeSubmit(SubComBudgetForecastOperateDto dto) {
        throw new UnsupportedOperationException();
    }


    @Override
    public List<SubComBudgetForecastVo> findListByCodes(List<String> codes) {
        throw new UnsupportedOperationException();
    }
    @Override
    public List<SubComBudgetForecastVo> findListByConditions(SubComBudgetForecastDto subComBudgetForecastDto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SubComBudgetForecastVo> listByBudgetForecastCodeList(List<String> budgetForecastCodeList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean lock(List<String> budgetForecastCodes, TimeUnit timeUnit, int time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unLock(List<String> budgetForecastCodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SubComBudgetForecastMainAdjustVo adjustQuery(String processNo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SubComBudgetForecastChangeVo changeQuery(String processNo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SubComBudgetForecastVo> listByOnlyKeys(List<String> onlykeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void submitApproval(SubComBudgetApprovalDto dto) {
        throw new UnsupportedOperationException();
    }

    /**
     * 根据唯一组合键获取
     *
     * @param uniqueKeys
     * @return
     */
    @Override
    public List<SubComBudgetForecastVo> findListByUniqueKeys(List<String> uniqueKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SubComBudgetForecastProcessVo findChangeDetailByProcessNo(String processNo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SubComBudgetForecastVo> findByBudgetItemCodes(List<String> budgetItemCodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateForecastRemainderAmount(String id, BigDecimal amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<SubComBudgetForecastVo> findSubBudgetForecastByConditions(Pageable pageable, SubComBudgetForecastDto selectDto) {
        throw new UnsupportedOperationException();
    }

    /**
     * 分子利润监控报表汇总
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<SubComBudgetForecastVo> findListByProfitMonitor(Pageable pageable, SubComBudgetForecastDto dto) {
        throw new UnsupportedOperationException();
    }

    /**
     * 分子利润监控报表自投费用汇总
     * @param records
     * @return
     */
    @Override
    public List<SubComAutoDetailVo> findAutoDetailSummary(List<SubComBudgetForecastVo> records) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<SubComBudgetForecastVo> findBySonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        return null;
    }
}
