/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.controller;

import com.alibaba.excel.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComApprovedAmountChangeLogService;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComAutoDetailService;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComBudgetForecastDetailService;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComBudgetForecastOtherService;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComInternalDetailService;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComOffDetailPlanService;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComOffPlanService;
import com.biz.crm.tpm.business.budget.forecast.local.service.async.ExternalAutoAsync;
import com.biz.crm.tpm.business.budget.forecast.local.service.async.InternalAutoAsync;
import com.biz.crm.tpm.business.budget.forecast.local.service.async.OneselfCastAutoAsync;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComAutoDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetApprovalDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastAdjustDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastOperateDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComInternalDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComOffDetailPlanDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComOffPlanDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComAutoDetailVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastChangeVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastDetailVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastMainAdjustVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastProcessVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComInternalDetailVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComOffDetailPlanVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComOffPlanVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/budget/forecast/subsidiary"})
@Api(tags={"\u9884\u7b97\u9884\u6d4b"})
public class SubComBudgetForecastController {
    private static final Logger log = LoggerFactory.getLogger(SubComBudgetForecastController.class);
    @Autowired(required=false)
    private SubComOffPlanService subComOffPlanService;
    @Autowired(required=false)
    private SubComAutoDetailService subComAutoDetailService;
    @Autowired(required=false)
    private SubComOffDetailPlanService subComOffDetailPlanService;
    @Autowired(required=false)
    private SubComInternalDetailService subComInternalDetailService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private SubComBudgetForecastDetailService subComBudgetForecastDetailService;
    @Autowired(required=false)
    private SubComApprovedAmountChangeLogService subComApprovedAmountChangeLogService;
    @Autowired(required=false)
    private SubComBudgetForecastOtherService subComBudgetForecastOtherService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ExternalAutoAsync externalAutoAsync;
    @Autowired(required=false)
    private InternalAutoAsync internalAutoAsync;
    @Autowired(required=false)
    private OneselfCastAutoAsync oneselfCastAutoAsync;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<SubComBudgetForecastVo>> findSubComByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="subComBudgetForecastDto", value="\u9884\u7b97\u9879\u76ee\u4fe1\u606f") SubComBudgetForecastDto dto) {
        try {
            Page page = this.subComBudgetForecastService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u6240\u6709\u6570\u636e")
    @PostMapping(value={"/listByConditions"})
    public Result<List<SubComBudgetForecastVo>> listByConditions(@RequestBody SubComBudgetForecastDto dto) {
        try {
            List list = this.subComBudgetForecastService.listByConditions(dto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u64cd\u4f5c\u9884\u7b97\u9884\u6d4b\u6570\u636e")
    @PostMapping(value={"/operationBudgetForecast"})
    public Result<?> operationBudgetForecast(@RequestBody List<SubComBudgetForecastDetailDto> subComBudgetForecastDtoList) {
        try {
            this.subComBudgetForecastService.operationBudgetForecast(subComBudgetForecastDtoList);
            return Result.ok((String)"\u64cd\u4f5c\u9884\u7b97\u9884\u6d4b\u6570\u636e\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801+\u5e74\u6708\u53d6\u5206\u5b50\u516c\u53f8\u7a0e\u91d1\u53ca\u9644\u52a0")
    @PostMapping(value={"/queryTaxAndAddition"})
    public Result<BigDecimal> queryTaxAndAddition(@RequestBody SubComBudgetForecastVo subComBudgetForecastVo) {
        try {
            BigDecimal result = this.subComBudgetForecastService.queryTaxAndAddition(subComBudgetForecastVo);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5e74\u6708\u8ba1\u7b97\u70b9\u5185\u8d39\u7528")
    @GetMapping(value={"/manualInternalData"})
    public Result<?> manualInternalData(@RequestParam(value="yearMonth") String yearMonth) {
        try {
            AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
            boolean flag = this.redisLockService.isLock("sub_com_budget_forecast_out_job_lock:" + yearMonth);
            if (flag) {
                return Result.error((String)"\u4e0a\u6b21\u70b9\u5185\u8d39\u7528\u8ba1\u7b97\u4efb\u52a1\u672a\u5b8c\u6210,\u8bf7\u8010\u5fc3\u7b49\u5f85!");
            }
            String rule = "\\d{4}-\\d{2}";
            if (Pattern.matches(rule, yearMonth)) {
                this.internalAutoAsync.manualInternalData(yearMonth, abstractLoginUser);
            } else {
                Result.error((String)"\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
            }
            return Result.ok((String)"\u6267\u884c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5e74\u6708\u8ba1\u7b97\u70b9\u5185\u8d39\u7528")
    @PostMapping(value={"/manualInternalData"})
    public Result<?> manualInternalDataPost(@RequestBody SubComBudgetForecastDto dto) {
        try {
            AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
            boolean flag = this.redisLockService.isLock("sub_com_budget_forecast_out_job_lock:" + dto.getYearMonthLy());
            if (flag) {
                return Result.error((String)"\u4e0a\u6b21\u70b9\u5185\u8d39\u7528\u8ba1\u7b97\u4efb\u52a1\u672a\u5b8c\u6210,\u8bf7\u8010\u5fc3\u7b49\u5f85!");
            }
            String rule = "\\d{4}-\\d{2}";
            if (Pattern.matches(rule, dto.getYearMonthLy())) {
                this.internalAutoAsync.manualInternalData(dto.getYearMonthLy(), abstractLoginUser);
            } else {
                Result.error((String)"\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
            }
            return Result.ok((String)"\u6267\u884c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5e74\u6708\u8ba1\u7b97\u70b9\u5916\u8d39\u7528")
    @PostMapping(value={"/manualExternalData"})
    public Result<?> manualExternalDataPost(@RequestBody SubComBudgetForecastDto dto) {
        try {
            AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
            boolean flag = this.redisLockService.isLock("sub_com_budget_forecast_out_job_lock:" + dto.getYearMonthLy());
            if (flag) {
                return Result.error((String)"\u4e0a\u6b21\u70b9\u5916\u8d39\u7528\u8ba1\u7b97\u4efb\u52a1\u672a\u5b8c\u6210,\u8bf7\u8010\u5fc3\u7b49\u5f85!");
            }
            String rule = "\\d{4}-\\d{2}";
            if (Pattern.matches(rule, dto.getYearMonthLy())) {
                this.externalAutoAsync.calExternalData(dto.getYearMonthLy(), abstractLoginUser);
            } else {
                Result.error((String)"\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
            }
            return Result.ok((String)"\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u8be2\u7ed3\u679c");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5e74\u6708\u8ba1\u7b97\u70b9\u5185\u8d39\u7528")
    @GetMapping(value={"/manualExternalData"})
    public Result<?> manualExternalData(@RequestParam(value="yearMonth") String yearMonth) {
        try {
            AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
            boolean flag = this.redisLockService.isLock("sub_com_budget_forecast_out_job_lock:" + yearMonth);
            if (flag) {
                return Result.error((String)"\u4e0a\u6b21\u70b9\u5185\u8d39\u7528\u8ba1\u7b97\u4efb\u52a1\u672a\u5b8c\u6210,\u8bf7\u8010\u5fc3\u7b49\u5f85!");
            }
            String rule = "\\d{4}-\\d{2}";
            if (Pattern.matches(rule, yearMonth)) {
                this.externalAutoAsync.calExternalData(yearMonth, abstractLoginUser);
            } else {
                Result.error((String)"\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
            }
            return Result.ok((String)"\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u8be2\u7ed3\u679c");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u9009\u4e2d\u7684\u6d3b\u52a8\u65b9\u6848\u7684\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u751f\u6210\u9884\u7b97\u9884\u6d4b")
    @PostMapping(value={"/generateBudgetForecastForActivityPlan"})
    public Result<?> generateBudgetForecastForActivityPlan(@RequestBody List<ActivityPlanItemDto> activityPlanItemList) {
        try {
            this.subComBudgetForecastService.generateBudgetForecastForActivityPlan(activityPlanItemList);
            return Result.ok((String)"\u6267\u884c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u660e\u7ec6\u6570\u636e")
    @GetMapping(value={"/detail/findByConditions"})
    public Result<Page<SubComBudgetForecastDetailVo>> findSubComDetailByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="SubComBudgetForecastDetailDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b") SubComBudgetForecastDetailDto dto) {
        try {
            Page<SubComBudgetForecastDetailVo> page = this.subComBudgetForecastDetailService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u81ea\u6295\u8d39\u7528\u660e\u7ec6")
    @GetMapping(value={"/auto/detail"})
    public Result<SubComAutoDetailVo> detail(@ApiParam(name="SubComAutoDetailDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b-\u81ea\u6295\u8d39\u7528\u660e\u7ec6") SubComAutoDetailDto dto) {
        try {
            SubComAutoDetailVo result = this.subComAutoDetailService.detail(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u6539\u5206\u5b50\u516c\u53f8\u81ea\u6295\u8d39\u7528\u6838\u51c6\u91d1\u989d")
    @PostMapping(value={"/auto/update"})
    public Result<?> update(@RequestBody SubComAutoDetailDto dto) {
        try {
            this.subComAutoDetailService.update(dto);
            return Result.ok((String)"\u6838\u51c6\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u70b9\u5185\u8d39\u7528\u660e\u7ec6")
    @GetMapping(value={"/internal/detail"})
    public Result<Page<SubComInternalDetailVo>> detail(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="SubComInternalDetailDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b-\u81ea\u6295\u8d39\u7528\u660e\u7ec6") SubComInternalDetailDto dto) {
        try {
            Page<SubComInternalDetailVo> result = this.subComInternalDetailService.detail(pageable, dto);
            return Result.ok(result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6838\u51c6\u70b9\u5185\u8d39\u7528")
    @PostMapping(value={"/internal/update"})
    public Result<?> internalUpdate(@RequestBody List<SubComInternalDetailDto> dtoList) {
        try {
            this.subComInternalDetailService.internalUpdate(dtoList);
            return Result.ok((String)"\u6838\u51c6\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u70b9\u5916\u8d39\u7528\u65b9\u6848")
    @GetMapping(value={"/off/plan/detail"})
    public Result<Page<SubComOffPlanVo>> detail(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="SubComInternalDetailDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b-\u5e97\u5916\u65b9\u6848") SubComOffPlanDto dto) {
        try {
            Page<SubComOffPlanVo> result = this.subComOffPlanService.detail(pageable, dto);
            return Result.ok(result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u70b9\u5916\u8d39\u7528\u7ec6\u6848")
    @GetMapping(value={"/off/detail/plan/detail"})
    public Result<Page<SubComOffDetailPlanVo>> detail(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="SubComInternalDetailDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b-\u70b9\u5916\u7ec6\u6848") SubComOffDetailPlanDto dto) {
        try {
            Page<SubComOffDetailPlanVo> result = this.subComOffDetailPlanService.detail(pageable, dto);
            return Result.ok(result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6838\u51c6\u70b9\u5916\u8d39\u7528")
    @PostMapping(value={"/off/update"})
    public Result<?> offUpdate(@RequestBody List<SubComOffPlanDto> dtoList) {
        try {
            this.subComOffPlanService.offUpdate(dtoList);
            return Result.ok((String)"\u6838\u51c6\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u51c6\u91d1\u989d\u53d8\u66f4\u65e5\u5fd7\u67e5\u8be2")
    @GetMapping(value={"/approvedAmount/change/log"})
    public Result<?> getSubComBudgetForecastApprovedAmountChangeLog(@RequestParam(value="feeSourceCode") String feeSourceCode, @RequestParam(value="budgetForecastCode") String budgetForecastCode) {
        try {
            JSONArray logResult = this.subComApprovedAmountChangeLogService.getSubComBudgetForecastApprovedAmountChangeLog(feeSourceCode, budgetForecastCode);
            return Result.ok((Object)logResult);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u51c6\u91d1\u989d\u53d8\u66f4\u65e5\u5fd7\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/approvedAmount/change/log/detail"})
    public Result<?> getSubComBudgetForecastApprovedAmountChangeLogDetail(@RequestParam(value="feeSourceCode") String feeSourceCode, @RequestParam(value="changeLogId") String changeLogId) {
        try {
            JSONArray logResult = this.subComApprovedAmountChangeLogService.getSubComBudgetForecastApprovedAmountChangeLogDetail(feeSourceCode, changeLogId);
            return Result.ok((Object)logResult);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5408\u8ba1")
    @GetMapping(value={"summationBudgetAmount"})
    public Result<SubComBudgetForecastVo> summationBudgetAmount(@ApiParam(name="budgetForecastDto", value="\u9884\u7b97\u9884\u6d4b\u4fe1\u606f") SubComBudgetForecastDto dto) {
        try {
            SubComBudgetForecastVo summation = this.subComBudgetForecastService.summationBudgetAmount(dto);
            return Result.ok((Object)summation);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9009\u62e9\u6570\u636e\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"findById"})
    public Result<SubComBudgetForecastVo> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            SubComBudgetForecastVo vo = this.subComBudgetForecastService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8c03\u6574")
    @PostMapping(value={"adjust"})
    public Result adjust(@ApiParam(name="SubComBudgetForecastAdjustDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b") @RequestBody SubComBudgetForecastAdjustDto dto) {
        try {
            this.subComBudgetForecastService.adjust(dto);
            return Result.ok((String)"\u8c03\u6574\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d8\u66f4")
    @PostMapping(value={"change"})
    public Result change(@ApiParam(name="SubComBudgetForecastOperateDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b") @RequestBody SubComBudgetForecastOperateDto dto) {
        try {
            this.subComBudgetForecastService.change(dto);
            return Result.ok((String)"\u53d8\u66f4\u6210\u529f\u8fdb\u5165\u5ba1\u6279\u6d41");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u51bb\u7ed3")
    @PostMapping(value={"freeze"})
    public Result freeze(@ApiParam(name="SubComBudgetForecastOperateDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b") @RequestBody SubComBudgetForecastOperateDto dto) {
        try {
            this.subComBudgetForecastService.unOrFreeze(dto, BudgetOperationTypeEnum.FREEZE.getCode());
            return Result.ok((String)"\u51bb\u7ed3\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u89e3\u51bb")
    @PostMapping(value={"unfreeze"})
    public Result unfreeze(@ApiParam(name="SubComBudgetForecastOperateDto", value="\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b") @RequestBody SubComBudgetForecastOperateDto dto) {
        try {
            this.subComBudgetForecastService.unOrFreeze(dto, BudgetOperationTypeEnum.UNFREEZE.getCode());
            return Result.ok((String)"\u89e3\u51bb\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u4e2d\u67e5\u770b\u8c03\u6574\u660e\u7ec6\uff08bpm\u4f7f\u7528\uff09")
    @GetMapping(value={"adjustQuery"})
    public Result<SubComBudgetForecastMainAdjustVo> adjustQuery(@RequestParam(value="processNo") @ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u7801") String processNo) {
        try {
            SubComBudgetForecastMainAdjustVo adjustVo = this.subComBudgetForecastService.adjustQuery(processNo);
            return Result.ok((Object)adjustVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u4e2d\u67e5\u770b\u53d8\u66f4\u660e\u7ec6\uff08bpm\u4f7f\u7528\uff09")
    @GetMapping(value={"changeQuery"})
    public Result<SubComBudgetForecastChangeVo> changeQuery(@RequestParam(value="processNo") @ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u7801") String processNo) {
        try {
            SubComBudgetForecastChangeVo changeVo = this.subComBudgetForecastService.changeQuery(processNo);
            return Result.ok((Object)changeVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5355\u6761\u9884\u7b97\u9884\u6d4b\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"submitApproval"})
    public Result<?> submitApproval(@RequestBody SubComBudgetApprovalDto dto) {
        try {
            this.subComBudgetForecastService.submitApproval(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.subComBudgetForecastService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9009\u62e9\u6570\u636e\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"findChangeDetailByProcessNo"})
    public Result<SubComBudgetForecastProcessVo> findChangeDetailByProcessNo(@RequestParam(value="processNo") @ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u7801") String processNo) {
        try {
            SubComBudgetForecastProcessVo vo = this.subComBudgetForecastService.findChangeDetailByProcessNo(processNo);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5e74\u6708\u66f4\u65b0\u81ea\u6295\u8d39\u7528")
    @GetMapping(value={"/updateOneselfCastData"})
    public Result<?> updateOneselfCastData(@RequestParam(value="yearMonth") String yearMonth) {
        try {
            AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
            boolean flag = this.redisLockService.isLock("sub_com_budget_forecast:lock:oneself_cast:" + yearMonth);
            if (flag) {
                return Result.error((String)"\u4e0a\u6b21\u66f4\u65b0\u81ea\u6295\u8d39\u7528\u4efb\u52a1\u672a\u5b8c\u6210,\u8bf7\u8010\u5fc3\u7b49\u5f85!");
            }
            this.oneselfCastAutoAsync.updateOneselfCastData(yearMonth, abstractLoginUser);
            return Result.ok((String)"\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u8be2\u7ed3\u679c");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u81ea\u6295\u8d39\u7528\u63d0\u793a")
    @GetMapping(value={"/autoAmount/excessPrompt"})
    public Result<List<String>> excessPrompt(@RequestParam(value="total", required=false) @ApiParam(name="total", value="total") Integer total) {
        try {
            List list = this.subComBudgetForecastService.excessPrompt(total);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4e0b\u8f7d\u5206\u5b50\u516c\u53f8\u81ea\u6295\u8d39\u7528\u660e\u7ec6")
    @GetMapping(value={"/auto/detail/download"})
    public void download(@RequestParam(value="id") String id, HttpServletResponse response) throws IOException {
        boolean lock = false;
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            lock = this.redisLockService.tryLock("sub_com_budget_forecast_download:lock:" + id, TimeUnit.HOURS, 1L);
            if (!lock) {
                throw new RuntimeException("\u6709\u76f8\u540c\u6587\u4ef6\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e..");
            }
            this.subComAutoDetailService.download(id, response);
        }
        catch (RuntimeException e) {
            log.error("\u4e0b\u8f7d\u5206\u5b50\u516c\u53f8\u81ea\u6295\u8d39\u7528\u660e\u7ec6\u51fa\u9519", (Throwable)e);
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap map = MapUtils.newHashMap();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25," + e.getMessage());
            response.getWriter().println(JSON.toJSONString((Object)map));
        }
        finally {
            if (lock) {
                this.redisLockService.unlock("sub_com_budget_forecast_download:lock:" + id);
            }
        }
    }
}

