/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.forecast.local.mapper.SubComBudgetForecastDetailMapper;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastDetailExportVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubComBudgetForecastDetailExportProcess
implements ExportProcess<SubComBudgetForecastDetailExportVo> {
    @Autowired(required=false)
    private SubComBudgetForecastDetailMapper exportMapper;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        SubComBudgetForecastDetailDto dto = this.convertParams(params);
        Page<SubComBudgetForecastDetailExportVo> pageResult = this.exportMapper.findExportByConditions((Page<SubComBudgetForecastDetailExportVo>)new Page(0L, 1L), dto);
        Integer total = (int)pageResult.getTotal();
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    private SubComBudgetForecastDetailDto convertParams(Map<String, Object> params) {
        return (SubComBudgetForecastDetailDto)JSON.parseObject((String)JSON.toJSONString(params), SubComBudgetForecastDetailDto.class);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        SubComBudgetForecastDetailDto dto = this.convertParams(params);
        Page pageable = new Page((long)(vo.getPageNo() + 1), (long)this.getPageSize().intValue());
        Page<SubComBudgetForecastDetailExportVo> page = this.exportMapper.findExportByConditions((Page<SubComBudgetForecastDetailExportVo>)pageable, dto);
        return JSON.parseArray((String)JSON.toJSONString(this.adjustData(page.getRecords())));
    }

    public Class<SubComBudgetForecastDetailExportVo> findCrmExcelVoClass() {
        return SubComBudgetForecastDetailExportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_SUB_COM_BUDGET_FORECAST_DETAIL_EXPORT";
    }

    public String getBusinessName() {
        return "\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u660e\u7ec6\u5bfc\u51fa";
    }

    private List<SubComBudgetForecastDetailExportVo> adjustData(List<SubComBudgetForecastDetailExportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<SubComBudgetForecastDetailExportVo>(0);
        }
        Map mapDict = this.dictToolkitService.findMapByDictTypeCode("tpm_forecast_operation_type");
        for (SubComBudgetForecastDetailExportVo datum : data) {
            BusinessUnitEnum unitEnum;
            datum.setOperationType(mapDict.getOrDefault(datum.getOperationType(), datum.getOperationType()));
            if (!StringUtils.isNotBlank((CharSequence)datum.getBusinessUnitCode()) || null == (unitEnum = BusinessUnitEnum.codeToEnum((String)datum.getBusinessUnitCode()))) continue;
            datum.setBusinessUnitCode(unitEnum.getDesc());
        }
        return data;
    }
}

