/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComAutoDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.mapper.SubComAutoDetailMapper;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.AutoDetailAmountTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComAutoDetailVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComAutoDetailRepository
extends ServiceImpl<SubComAutoDetailMapper, SubComAutoDetailEntity> {
    public void deleteByForecastCode(String budgetForecastCode) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            return;
        }
        List subComAutoDetailEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComAutoDetailEntity::getBudgetForecastCode, (Object)budgetForecastCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)subComAutoDetailEntityList)) {
            return;
        }
        subComAutoDetailEntityList.forEach(subComAutoDetailEntity -> subComAutoDetailEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.updateBatchById(subComAutoDetailEntityList);
    }

    public List<SubComAutoDetailEntity> listByForecastCode(String budgetForecastCode) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComAutoDetailEntity::getBudgetForecastCode, (Object)budgetForecastCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public BigDecimal queryTaxAndAddition(String budgetForecastCode) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            return BigDecimal.ZERO;
        }
        SubComAutoDetailEntity one = (SubComAutoDetailEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComAutoDetailEntity::getBudgetForecastCode, (Object)budgetForecastCode)).eq(SubComAutoDetailEntity::getBudgetAmountType, (Object)AutoDetailAmountTypeEnum.TAX_AMOUNT.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        if (Objects.isNull((Object)one)) {
            return BigDecimal.ZERO;
        }
        return one.getFeeAmount();
    }

    public List<SubComAutoDetailEntity> listByForecastCodes(List<String> budgetForecastCodeList) {
        if (CollectionUtils.isEmpty(budgetForecastCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(SubComAutoDetailEntity::getBudgetForecastCode, budgetForecastCodeList)).list();
    }

    public List<SubComAutoDetailVo> findAutoDetailSummary(List<SubComBudgetForecastVo> records) {
        return ((SubComAutoDetailMapper)this.baseMapper).findAutoDetailSummary(records);
    }
}

