/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.mapper.SubComBudgetForecastDetailMapper;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SubComBudgetForecastDetailRepository
extends ServiceImpl<SubComBudgetForecastDetailMapper, SubComBudgetForecastDetailEntity> {
    public List<SubComBudgetForecastDetailEntity> listByForecastCode(String budgetForecastCode) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastDetailEntity::getBudgetForecastCode, (Object)budgetForecastCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void delByBudgetForecastCode(String budgetForecastCode) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(SubComBudgetForecastDetailEntity::getBudgetForecastCode, (Object)budgetForecastCode)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(SubComBudgetForecastDetailEntity::getOperationType, (Object)ForecastOperationTypeEnum.INIT.getCode())).update();
    }

    public List<SubComBudgetForecastDetailEntity> listByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastDetailEntity::getProcessNo, (Object)processNo)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<SubComBudgetForecastDetailEntity> writeBackProcessNo(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(SubComBudgetForecastDetailEntity::getOperationType, (Object)ForecastOperationTypeEnum.USE.getCode())).in(SubComBudgetForecastDetailEntity::getBusinessCode, detailCodes)).list();
    }

    public List<SubComBudgetForecastDetailVo> findAmountDetailByBudgetForecastCode(String budgetForecastCode) {
        return ((SubComBudgetForecastDetailMapper)this.baseMapper).findAmountDetailByBudgetForecastCode(budgetForecastCode, TenantUtils.getTenantCode());
    }

    public void updateProcessNoById(String id, String processNo) {
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)processNo)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).set(SubComBudgetForecastDetailEntity::getProcessNo, (Object)processNo)).update();
    }
}

