/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComOffPlanEntity;
import com.biz.crm.tpm.business.budget.forecast.local.mapper.SubComBudgetForecastMapper;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.dto.ProfitGoalDiscountDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class SubComBudgetForecastRepository
extends ServiceImpl<SubComBudgetForecastMapper, SubComBudgetForecastEntity> {
    @Autowired(required=false)
    private SubComBudgetForecastMapper subComBudgetForecastMapper;

    public List<SubComBudgetForecastEntity> listByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).list();
    }

    public SubComBudgetForecastEntity listDimension(ProfitGoalDiscountDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) || StringUtils.isEmpty((CharSequence)dto.getYearMonthLy()) || StringUtils.isEmpty((CharSequence)dto.getOrgCode())) {
            return null;
        }
        return (SubComBudgetForecastEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(SubComBudgetForecastEntity::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(SubComBudgetForecastEntity::getYearMonthLy, (Object)dto.getYearMonthLy())).eq(SubComBudgetForecastEntity::getOrgCode, (Object)dto.getOrgCode())).eq(SubComBudgetForecastEntity::getFeeSourceCode, (Object)FeeSourceEnum.AUTO_FEE.getCode())).one());
    }

    public SubComBudgetForecastEntity getByCode(String budgetForecastCode) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            return null;
        }
        return (SubComBudgetForecastEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastEntity::getBudgetForecastCode, (Object)budgetForecastCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public SubComBudgetForecastEntity getByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return null;
        }
        return (SubComBudgetForecastEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastEntity::getProcessNo, (Object)processNo)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<SubComBudgetForecastEntity> listByConditions(SubComBudgetForecastDto subComBudgetForecastDto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)subComBudgetForecastDto.getBusinessFormatCode()), SubComBudgetForecastEntity::getBusinessFormatCode, (Object)subComBudgetForecastDto.getBusinessFormatCode())).eq(!StringUtils.isEmpty((CharSequence)subComBudgetForecastDto.getBusinessUnitCode()), SubComBudgetForecastEntity::getBusinessUnitCode, (Object)subComBudgetForecastDto.getBusinessUnitCode())).eq(!StringUtils.isEmpty((CharSequence)subComBudgetForecastDto.getOrgCode()), SubComBudgetForecastEntity::getOrgCode, (Object)subComBudgetForecastDto.getOrgCode())).in(!CollectionUtils.isEmpty((Collection)subComBudgetForecastDto.getYearMonthList()), SubComBudgetForecastEntity::getYearMonthLy, (Collection)subComBudgetForecastDto.getYearMonthList())).in(!CollectionUtils.isEmpty((Collection)subComBudgetForecastDto.getBudgetItemCodeList()), SubComBudgetForecastEntity::getBudgetItemCode, (Collection)subComBudgetForecastDto.getBudgetItemCodeList())).eq(!StringUtils.isEmpty((CharSequence)subComBudgetForecastDto.getYearMonthLy()), SubComBudgetForecastEntity::getYearMonthLy, (Object)subComBudgetForecastDto.getYearMonthLy())).eq(!StringUtils.isEmpty((CharSequence)subComBudgetForecastDto.getFeeSourceCode()), SubComBudgetForecastEntity::getFeeSourceCode, (Object)subComBudgetForecastDto.getFeeSourceCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public SubComBudgetForecastEntity queryTaxAndAddition(SubComBudgetForecastVo subComBudgetForecastVo) {
        Validate.notNull((Object)subComBudgetForecastVo, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)subComBudgetForecastVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)subComBudgetForecastVo.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastEntity::getOrgCode, (Object)subComBudgetForecastVo.getOrgCode())).eq(SubComBudgetForecastEntity::getYearMonthLy, (Object)subComBudgetForecastVo.getYearMonthLy())).eq(SubComBudgetForecastEntity::getFeeSourceCode, (Object)FeeSourceEnum.AUTO_FEE.getCode())).eq(StringUtils.isNotEmpty((CharSequence)subComBudgetForecastVo.getBusinessFormatCode()), SubComBudgetForecastEntity::getBusinessFormatCode, (Object)subComBudgetForecastVo.getBusinessFormatCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        return (SubComBudgetForecastEntity)((Object)list.get(0));
    }

    public List<SubComBudgetForecastEntity> listByCodes(List<String> budgetForecastCodeList, String enableStatus) {
        if (CollectionUtils.isEmpty(budgetForecastCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).in(SubComBudgetForecastEntity::getBudgetForecastCode, budgetForecastCodeList)).list();
    }

    public List<SubComBudgetForecastEntity> listByConditions(String yearMonth, String feeSourceCode) {
        if (StringUtils.isEmpty((CharSequence)yearMonth) && StringUtils.isEmpty((CharSequence)feeSourceCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastEntity::getYearMonthLy, (Object)yearMonth)).eq(SubComBudgetForecastEntity::getFeeSourceCode, (Object)feeSourceCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void resetBudgetAmount(String yearMonth, String feeSourceCode) {
        if (StringUtils.isEmpty((CharSequence)yearMonth) && StringUtils.isEmpty((CharSequence)feeSourceCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(SubComBudgetForecastEntity::getBudgetAmount, (Object)BigDecimal.ZERO)).eq(SubComBudgetForecastEntity::getYearMonthLy, (Object)yearMonth)).eq(SubComBudgetForecastEntity::getFeeSourceCode, (Object)feeSourceCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public SubComBudgetForecastEntity findForOffPlan(SubComOffPlanEntity entity) {
        SubComBudgetForecastEntity one = (SubComBudgetForecastEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastEntity::getYearMonthLy, (Object)entity.getYearMonthLy())).eq(SubComBudgetForecastEntity::getFeeSourceCode, (Object)FeeSourceEnum.OFF_POINT_FEE.getCode())).eq(SubComBudgetForecastEntity::getBudgetItemCode, (Object)entity.getBudgetItemCode())).eq(SubComBudgetForecastEntity::getOrgCode, (Object)entity.getOrgCode())).one());
        return one;
    }

    public SubComBudgetForecastEntity findBySubComBudgetForecastDto(SubComBudgetForecastDto forecastDto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComBudgetForecastEntity::getYearMonthLy, (Object)forecastDto.getYearMonthLy())).eq(SubComBudgetForecastEntity::getBusinessFormatCode, (Object)forecastDto.getBusinessFormatCode())).eq(SubComBudgetForecastEntity::getBusinessUnitCode, (Object)forecastDto.getBusinessUnitCode())).eq(SubComBudgetForecastEntity::getOrgCode, (Object)forecastDto.getOrgCode())).eq(SubComBudgetForecastEntity::getBudgetItemCode, (Object)forecastDto.getBudgetItemCode())).eq(SubComBudgetForecastEntity::getFeeSourceCode, (Object)forecastDto.getFeeSourceCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u627e\u5230\u591a\u4e2a\u5206\u5b50\u9884\u7b97\u9884\u6d4b");
        return (SubComBudgetForecastEntity)((Object)list.get(0));
    }

    public SubComBudgetForecastEntity getById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (SubComBudgetForecastEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<SubComBudgetForecastEntity> findListByConditions(SubComBudgetForecastDto subComBudgetForecastDto) {
        if (Objects.isNull(subComBudgetForecastDto)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)subComBudgetForecastDto.getBusinessFormatCode()), SubComBudgetForecastEntity::getBusinessFormatCode, (Object)subComBudgetForecastDto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)subComBudgetForecastDto.getOrgCode()), SubComBudgetForecastEntity::getOrgCode, (Object)subComBudgetForecastDto.getOrgCode())).eq(StringUtils.isNotEmpty((CharSequence)subComBudgetForecastDto.getYearMonthLy()), SubComBudgetForecastEntity::getYearMonthLy, (Object)subComBudgetForecastDto.getYearMonthLy())).eq(StringUtils.isNotEmpty((CharSequence)subComBudgetForecastDto.getBusinessUnitCode()), SubComBudgetForecastEntity::getBusinessUnitCode, (Object)subComBudgetForecastDto.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)subComBudgetForecastDto.getFeeSourceCode()), SubComBudgetForecastEntity::getFeeSourceCode, (Object)subComBudgetForecastDto.getFeeSourceCode())).list();
    }

    public List<SubComBudgetForecastVo> listByOnlyKeys(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return new ArrayList<SubComBudgetForecastVo>();
        }
        return ((SubComBudgetForecastMapper)this.baseMapper).listByOnlyKeys(onlyKeys, TenantUtils.getTenantCode());
    }

    public List<SubComBudgetForecastVo> findListByUniqueKeys(List<String> uniqueKeys) {
        if (CollectionUtils.isEmpty(uniqueKeys)) {
            return new ArrayList<SubComBudgetForecastVo>();
        }
        List<SubComBudgetForecastVo> list = this.subComBudgetForecastMapper.findListByUniqueKeys(uniqueKeys);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<SubComBudgetForecastVo>();
        }
        return list;
    }

    public List<SubComBudgetForecastEntity> findByBudgetItemCodes(List<String> budgetCodes) {
        if (CollectionUtils.isEmpty(budgetCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(SubComBudgetForecastEntity::getBudgetItemCode, budgetCodes)).list();
    }

    public void updateForecastRemainderAmount(String id, BigDecimal amount) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidEntity::getId, (Object)id)).set(SubComBudgetForecastEntity::getRemainderAmount, (Object)amount)).update();
    }

    public Page<SubComBudgetForecastVo> findListByProfitMonitor(Page<SubComBudgetForecastVo> page, SubComBudgetForecastDto dto) {
        return ((SubComBudgetForecastMapper)this.baseMapper).findListByProfitMonitor(page, dto);
    }

    public Page<SubComBudgetForecastVo> findBySonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (CollectionUtils.isEmpty(yearMonthList)) {
            return page;
        }
        return ((SubComBudgetForecastMapper)this.baseMapper).findBySonCompanyBudgetWarn((Page<SubComBudgetForecastVo>)page, yearMonthList, orgCode, saleCompanyCode, channelCode, saleGroupCode, customerCode, budgetItemCode);
    }
}

