/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.async;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ExternalAutoAsync {
    private static final Logger log = LoggerFactory.getLogger(ExternalAutoAsync.class);
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @Async
    public void calExternalData(String yearMonth, AbstractCrmUserIdentity abstractLoginUser) {
        this.loginUserService.refreshAuthentication((Object)abstractLoginUser);
        String lockKey = "sub_com_budget_forecast_out_job_lock:" + yearMonth;
        boolean lock = true;
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4L);
            Assert.isTrue((boolean)lock, (String)"\u8ba1\u7b97\u70b9\u5916\u8d39\u7528\u52a0\u9501\u5931\u8d25");
            this.subComBudgetForecastService.calExternalData(yearMonth);
            log.info("=====>     \u8ba1\u7b97\u70b9\u5916\u8d39\u7528\u6210\u529f     <=====");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }
}

