/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.forecast.local.entity.BudgetForecastEntity;
import com.biz.crm.tpm.business.budget.forecast.local.mapper.BudgetForecastMapper;
import com.biz.crm.tpm.business.budget.forecast.local.repository.BudgetForecastRepository;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.BudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.BudgetForecastLogEventDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.event.BudgetForecastLogEventListener;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.BudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BudgetForecastServiceImpl
implements BudgetForecastService {
    private static final Logger log = LoggerFactory.getLogger(BudgetForecastServiceImpl.class);
    @Autowired(required=false)
    private BudgetForecastMapper budgetForecastMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private BudgetForecastRepository budgetForecastRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<BudgetForecastVo> findByConditions(Pageable pageable, BudgetForecastDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new BudgetForecastDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.budgetForecastMapper.findByConditions((Page<BudgetForecastVo>)page, dto);
    }

    public void importSave(List<BudgetForecastDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        importList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        ArrayList budgetItemEntities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(importList, BudgetForecastDto.class, BudgetForecastEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.budgetForecastRepository.saveBatch(budgetItemEntities);
        importList.forEach(dto -> {
            BudgetForecastLogEventDto logEventDto = new BudgetForecastLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = BudgetForecastLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetForecastLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<BudgetForecastEntity> budgetForecastEntities = this.budgetForecastRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(budgetForecastEntities)) {
            return;
        }
        budgetForecastEntities.forEach(budgetForecastEntity -> budgetForecastEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.budgetForecastRepository.updateBatchById(budgetForecastEntities);
        budgetForecastEntities.forEach(budgetForecastEntity -> {
            BudgetForecastLogEventDto logEventDto = new BudgetForecastLogEventDto();
            logEventDto.setOriginal((BudgetForecastDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetForecastEntity, BudgetForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = BudgetForecastLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetForecastLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
    }
}

