/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComAutoDetailApprovedAmountChangeLogEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComAutoDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastEntity;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComAutoDetailApprovedAmountChangeLogRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComAutoDetailRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastRepository;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComAutoDetailService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComAutoDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.AutoDetailAmountTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComAutoDetailVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComFixedPayDetailVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.BudgetAmountTypeEnum;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.enumeration.TpmSubsidiaryYearBudgetDetailTypeEnum;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.service.TpmSubsidiaryYearBudgetService;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetMonthDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SubComAutoDetailServiceImpl
implements SubComAutoDetailService {
    private static final Logger log = LoggerFactory.getLogger(SubComAutoDetailServiceImpl.class);
    @Resource
    private SubComAutoDetailRepository subComAutoDetailRepository;
    @Resource
    private SubComBudgetForecastRepository subComBudgetForecastRepository;
    @Resource
    private SubComAutoDetailApprovedAmountChangeLogRepository subComAutoDetailApprovedAmountChangeLogRepository;
    @Resource
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmSubsidiaryYearBudgetService tpmSubsidiaryYearBudgetService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;

    @Override
    public SubComAutoDetailVo detail(SubComAutoDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getId()) && StringUtils.isBlank((CharSequence)dto.getBudgetForecastCode())) {
            throw new IllegalArgumentException("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u6216id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SubComBudgetForecastEntity budgetForecastEntity = null;
        if (!StringUtils.isBlank((CharSequence)dto.getId())) {
            budgetForecastEntity = this.subComBudgetForecastRepository.getById(dto.getId());
        } else if (!StringUtils.isBlank((CharSequence)dto.getBudgetForecastCode())) {
            budgetForecastEntity = this.subComBudgetForecastRepository.getByCode(dto.getBudgetForecastCode());
        }
        Validate.notNull((Object)((Object)budgetForecastEntity), (String)("\u672a\u627e\u5230\u5bf9\u5e94\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\uff01" + dto.getBudgetForecastCode()), (Object[])new Object[0]);
        SubComAutoDetailVo subComAutoDetailVo = new SubComAutoDetailVo();
        ArrayList fixedPayDetailList = new ArrayList();
        subComAutoDetailVo.setOrgName(budgetForecastEntity.getOrgName());
        subComAutoDetailVo.setYearMonthLy(budgetForecastEntity.getYearMonthLy());
        subComAutoDetailVo.setApprovedAmount(budgetForecastEntity.getApprovedAmount());
        subComAutoDetailVo.setRemark(budgetForecastEntity.getRemark());
        List<SubComAutoDetailEntity> subComAutoDetailEntityList = this.subComAutoDetailRepository.listByForecastCode(budgetForecastEntity.getBudgetForecastCode());
        if (CollectionUtils.isEmpty(subComAutoDetailEntityList)) {
            return subComAutoDetailVo;
        }
        subComAutoDetailEntityList.forEach(subComAutoDetailEntity -> {
            String autoDetailAmountType = subComAutoDetailEntity.getBudgetAmountType();
            if (AutoDetailAmountTypeEnum.THEORY_INCOME.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailVo.setTheoryIncome(subComAutoDetailEntity.getFeeAmount());
            }
            if (AutoDetailAmountTypeEnum.THEORY_COST.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailVo.setTheoryCost(subComAutoDetailEntity.getFeeAmount());
            }
            if (AutoDetailAmountTypeEnum.THEORY_PROFIT.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailVo.setTheoryProfit(subComAutoDetailEntity.getFeeAmount());
            }
            if (BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(autoDetailAmountType)) {
                SubComFixedPayDetailVo subComFixedPayDetailVo = new SubComFixedPayDetailVo();
                subComFixedPayDetailVo.setBudgetItemCode(subComAutoDetailEntity.getBudgetItemCode());
                subComFixedPayDetailVo.setBudgetItemName(subComAutoDetailEntity.getBudgetItemName());
                subComFixedPayDetailVo.setFeeAmount(subComAutoDetailEntity.getFeeAmount());
                fixedPayDetailList.add(subComFixedPayDetailVo);
            }
            if (AutoDetailAmountTypeEnum.FIXED_PAY_TOTAL.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailVo.setFixedPayTotal(subComAutoDetailEntity.getFeeAmount());
            }
            if (AutoDetailAmountTypeEnum.PROFIT_GOAL.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailVo.setProfitGoal(subComAutoDetailEntity.getFeeAmount());
            }
            if (AutoDetailAmountTypeEnum.ASSESS_DEDUCTION.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailVo.setAssessDeduction(subComAutoDetailEntity.getFeeAmount());
            }
            if (AutoDetailAmountTypeEnum.TAX_AMOUNT.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailVo.setTaxAmount(subComAutoDetailEntity.getFeeAmount());
            }
            if (AutoDetailAmountTypeEnum.AUTO_AMOUNT.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailVo.setAutoAmount(subComAutoDetailEntity.getFeeAmount());
            }
        });
        subComAutoDetailVo.setFixedPayDetailList(fixedPayDetailList);
        subComAutoDetailVo.setMonthAfterDiscountSales(BigDecimal.ZERO);
        subComAutoDetailVo.setYearBeforeDiscountSales(BigDecimal.ZERO);
        subComAutoDetailVo.setYearAfterDiscountSales(BigDecimal.ZERO);
        subComAutoDetailVo.setYearAutoAmount(BigDecimal.ZERO);
        if (StringUtils.isNotBlank((CharSequence)budgetForecastEntity.getBusinessFormatCode()) && StringUtils.isNotBlank((CharSequence)budgetForecastEntity.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)budgetForecastEntity.getYearMonthLy()) && StringUtils.isNotBlank((CharSequence)budgetForecastEntity.getOrgCode())) {
            String[] split = budgetForecastEntity.getYearMonthLy().split("-");
            if (split.length >= 2) {
                TpmSubsidiaryYearBudgetDto selectDto = new TpmSubsidiaryYearBudgetDto();
                selectDto.setBusinessFormatCode(budgetForecastEntity.getBusinessFormatCode());
                selectDto.setBusinessUnitCode(budgetForecastEntity.getBusinessUnitCode());
                selectDto.setYearLy(split[0]);
                selectDto.setMonthLy(split[1].startsWith("0") ? split[1].replaceFirst("0", "") : split[1]);
                selectDto.setOrgCode(budgetForecastEntity.getOrgCode());
                List yearBudgetVoList = this.tpmSubsidiaryYearBudgetService.findByConditionsForSubAuto(selectDto);
                if (!CollectionUtils.isEmpty((Collection)yearBudgetVoList)) {
                    Map<String, List<TpmSubsidiaryYearBudgetMonthDetailVo>> yearBudgetVoMap = yearBudgetVoList.stream().collect(Collectors.groupingBy(TpmSubsidiaryYearBudgetMonthDetailVo::getBudgetDetailType));
                    yearBudgetVoMap.forEach((k, v) -> {
                        if (TpmSubsidiaryYearBudgetDetailTypeEnum.BEFORE_DISCOUNT.getCode().equals(k) && !CollectionUtils.isEmpty((Collection)v)) {
                            subComAutoDetailVo.setYearBeforeDiscountSales(v.stream().map(TpmSubsidiaryYearBudgetMonthDetailVo::getBudgetDetailAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                        }
                        if (TpmSubsidiaryYearBudgetDetailTypeEnum.AFTER_DISCOUNT.getCode().equals(k) && !CollectionUtils.isEmpty((Collection)v)) {
                            subComAutoDetailVo.setYearAfterDiscountSales(v.stream().map(TpmSubsidiaryYearBudgetMonthDetailVo::getBudgetDetailAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                        }
                        if (TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode().equals(k) && !CollectionUtils.isEmpty((Collection)v)) {
                            subComAutoDetailVo.setYearAutoAmount(v.stream().map(TpmSubsidiaryYearBudgetMonthDetailVo::getBudgetDetailAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                        }
                    });
                }
            }
            SalesPlanDto salesPlanDto = new SalesPlanDto();
            salesPlanDto.setBusinessFormatCode(budgetForecastEntity.getBusinessFormatCode());
            salesPlanDto.setBusinessUnitCode(budgetForecastEntity.getBusinessUnitCode());
            salesPlanDto.setOrgCode(budgetForecastEntity.getOrgCode());
            salesPlanDto.setYearMonthLy(budgetForecastEntity.getYearMonthLy());
            List salesPlanVoList = this.salesPlanService.findByConditions(salesPlanDto);
            if (!CollectionUtils.isEmpty((Collection)salesPlanVoList)) {
                subComAutoDetailVo.setMonthAfterDiscountSales(salesPlanVoList.stream().map(SalesPlanVo::getDiscountedIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        subComAutoDetailVo.setMonthBeforeDiscountSales(Optional.ofNullable(subComAutoDetailVo.getTheoryIncome()).orElse(BigDecimal.ZERO));
        subComAutoDetailVo.setMonthAutoAmount(Optional.ofNullable(subComAutoDetailVo.getAutoAmount()).orElse(BigDecimal.ZERO));
        subComAutoDetailVo.setMonthBeforeDiscountRatio(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(subComAutoDetailVo.getMonthBeforeDiscountSales()) != 0) {
            subComAutoDetailVo.setMonthBeforeDiscountRatio(subComAutoDetailVo.getMonthAutoAmount().divide(subComAutoDetailVo.getMonthBeforeDiscountSales(), 10, 4));
        }
        subComAutoDetailVo.setMonthAfterDiscountRatio(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(subComAutoDetailVo.getMonthAfterDiscountSales()) != 0) {
            subComAutoDetailVo.setMonthAfterDiscountRatio(subComAutoDetailVo.getMonthAutoAmount().divide(subComAutoDetailVo.getMonthAfterDiscountSales(), 10, 4));
        }
        subComAutoDetailVo.setYearBeforeDiscountRatio(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(subComAutoDetailVo.getYearBeforeDiscountSales()) != 0) {
            subComAutoDetailVo.setYearBeforeDiscountRatio(subComAutoDetailVo.getYearAutoAmount().divide(subComAutoDetailVo.getYearBeforeDiscountSales(), 10, 4));
        }
        subComAutoDetailVo.setYearAfterDiscountRatio(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(subComAutoDetailVo.getYearAfterDiscountSales()) != 0) {
            subComAutoDetailVo.setYearAfterDiscountRatio(subComAutoDetailVo.getYearAutoAmount().divide(subComAutoDetailVo.getYearAfterDiscountSales(), 10, 4));
        }
        subComAutoDetailVo.setDiffBeforeDiscountRatio(subComAutoDetailVo.getMonthBeforeDiscountRatio().subtract(subComAutoDetailVo.getYearBeforeDiscountRatio()));
        subComAutoDetailVo.setDiffAfterDiscountRatio(subComAutoDetailVo.getMonthAfterDiscountRatio().subtract(subComAutoDetailVo.getYearAfterDiscountRatio()));
        subComAutoDetailVo.setDiffAutoAmount(subComAutoDetailVo.getMonthAutoAmount().subtract(subComAutoDetailVo.getYearAutoAmount()));
        subComAutoDetailVo.setDiffBeforeDiscountSales(subComAutoDetailVo.getMonthBeforeDiscountSales().subtract(subComAutoDetailVo.getYearBeforeDiscountSales()));
        subComAutoDetailVo.setDiffAfterDiscountSales(subComAutoDetailVo.getMonthAfterDiscountSales().subtract(subComAutoDetailVo.getYearAfterDiscountSales()));
        BigDecimal decimal = new BigDecimal(100);
        if (Objects.nonNull(subComAutoDetailVo.getYearBeforeDiscountRatio())) {
            subComAutoDetailVo.setYearBeforeDiscountRatio(subComAutoDetailVo.getYearBeforeDiscountRatio().setScale(4, 5));
            subComAutoDetailVo.setYearBeforeDiscountRatioStr(subComAutoDetailVo.getYearBeforeDiscountRatio().multiply(decimal).toString() + "%");
        }
        if (Objects.nonNull(subComAutoDetailVo.getMonthBeforeDiscountRatio())) {
            subComAutoDetailVo.setMonthBeforeDiscountRatio(subComAutoDetailVo.getMonthBeforeDiscountRatio().setScale(4, 5));
            subComAutoDetailVo.setMonthBeforeDiscountRatioStr(subComAutoDetailVo.getMonthBeforeDiscountRatio().multiply(decimal).toString() + "%");
        }
        if (Objects.nonNull(subComAutoDetailVo.getDiffBeforeDiscountRatio())) {
            subComAutoDetailVo.setDiffBeforeDiscountRatio(subComAutoDetailVo.getDiffBeforeDiscountRatio().setScale(4, 5));
            subComAutoDetailVo.setDiffBeforeDiscountRatioStr(subComAutoDetailVo.getDiffBeforeDiscountRatio().multiply(decimal).toString() + "%");
        }
        if (Objects.nonNull(subComAutoDetailVo.getYearAfterDiscountRatio())) {
            subComAutoDetailVo.setYearAfterDiscountRatio(subComAutoDetailVo.getYearAfterDiscountRatio().setScale(4, 5));
            subComAutoDetailVo.setYearAfterDiscountRatioStr(subComAutoDetailVo.getYearAfterDiscountRatio().multiply(decimal).toString() + "%");
        }
        if (Objects.nonNull(subComAutoDetailVo.getMonthAfterDiscountRatio())) {
            subComAutoDetailVo.setMonthAfterDiscountRatio(subComAutoDetailVo.getMonthAfterDiscountRatio().setScale(4, 5));
            subComAutoDetailVo.setMonthAfterDiscountRatioStr(subComAutoDetailVo.getMonthAfterDiscountRatio().multiply(decimal).toString() + "%");
        }
        if (Objects.nonNull(subComAutoDetailVo.getDiffAfterDiscountRatio())) {
            subComAutoDetailVo.setDiffAfterDiscountRatio(subComAutoDetailVo.getDiffAfterDiscountRatio().setScale(4, 5));
            subComAutoDetailVo.setDiffAfterDiscountRatioStr(subComAutoDetailVo.getDiffAfterDiscountRatio().multiply(decimal).toString() + "%");
        }
        log.info("\u5206\u5b50\u9884\u7b97\u9884\u6d4b\uff0c\u81ea\u6295\u8be6\u60c5:{}", (Object)subComAutoDetailVo);
        return subComAutoDetailVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SubComAutoDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBudgetForecastCode(), (String)"\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getApprovedAmountStr()) && dto.getApprovedAmount() == null) {
            throw new UnsupportedOperationException("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u6838\u51c6\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Validate.notEmpty((CharSequence)dto.getRemark(), (String)"\u6838\u51c6\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.getByCode(dto.getBudgetForecastCode());
        subComBudgetForecastEntity.setRemark(dto.getRemark());
        if (dto.getApprovedAmount() != null) {
            subComBudgetForecastEntity.setApprovedAmount(dto.getApprovedAmount());
        } else {
            subComBudgetForecastEntity.setApprovedAmount(new BigDecimal(dto.getApprovedAmountStr()));
        }
        subComBudgetForecastEntity.setFirstBudgetAmount(subComBudgetForecastEntity.getBudgetAmount().min(Optional.ofNullable(subComBudgetForecastEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
        subComBudgetForecastEntity.setRemainderAmount(subComBudgetForecastEntity.getFirstBudgetAmount().subtract(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(subComBudgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(subComBudgetForecastEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)));
        this.subComBudgetForecastRepository.updateById((Object)subComBudgetForecastEntity);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        SubComAutoDetailApprovedAmountChangeLogEntity logEntity = new SubComAutoDetailApprovedAmountChangeLogEntity();
        logEntity.setApprovedAmount(subComBudgetForecastEntity.getApprovedAmount());
        logEntity.setBudgetForecastCode(dto.getBudgetForecastCode());
        logEntity.setModifyPositionCode(loginDetails.getPostCode());
        logEntity.setModifyPositionName(loginDetails.getPostName());
        logEntity.setTenantCode(TenantUtils.getTenantCode());
        logEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        logEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.subComAutoDetailApprovedAmountChangeLogRepository.save((Object)logEntity);
    }

    @Override
    public void download(String id, HttpServletResponse response) throws IOException {
        SubComAutoDetailDto dto = new SubComAutoDetailDto();
        dto.setId(id);
        SubComAutoDetailVo subComAutoDetailVo = this.detail(dto);
        log.info("\u4e0b\u8f7d\u5206\u5b50\u516c\u53f8\u81ea\u6295\u8d39\u7528\u660e\u7ec6,subComAutoDetailVo:{}", (Object)subComAutoDetailVo);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(subComAutoDetailVo.getOrgName() + subComAutoDetailVo.getYearMonthLy() + "\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u81ea\u6295\u8d39\u7528", "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        HashMap<String, SubComFixedPayDetailVo> fixedPayDetailVoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)subComAutoDetailVo.getFixedPayDetailList())) {
            fixedPayDetailVoMap = subComAutoDetailVo.getFixedPayDetailList().stream().collect(Collectors.toMap(SubComFixedPayDetailVo::getBudgetItemCode, Function.identity(), (v1, v2) -> v2));
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        this.setExcelForm(sheet, fixedPayDetailVoMap);
        CellStyle cellStyle = workbook.createCellStyle();
        DataFormat format = workbook.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("#0.000000"));
        this.fillExcelData(sheet, subComAutoDetailVo, fixedPayDetailVoMap, cellStyle);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            workbook.close();
        }
    }

    private void setExcelForm(Sheet sheet, Map<String, SubComFixedPayDetailVo> fixedPayDetailVoMap) {
        if (Objects.isNull(sheet)) {
            return;
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 3, 4));
        int i = 4;
        if (!CollectionUtils.isEmpty(fixedPayDetailVoMap)) {
            Set<String> keySet = fixedPayDetailVoMap.keySet();
            if (keySet.size() <= 1) {
                sheet.addMergedRegion(new CellRangeAddress(i, i, 1, 2));
                sheet.addMergedRegion(new CellRangeAddress(i, i, 3, 4));
            } else {
                sheet.addMergedRegion(new CellRangeAddress(i, i + keySet.size() - 1, 0, 0));
                for (int a = 0; a < keySet.size(); ++a) {
                    sheet.addMergedRegion(new CellRangeAddress(i + a, i + a, 1, 2));
                    sheet.addMergedRegion(new CellRangeAddress(i + a, i + a, 3, 4));
                }
            }
            i = i + keySet.size() - 1;
        } else {
            sheet.addMergedRegion(new CellRangeAddress(i, i, 0, 2));
            sheet.addMergedRegion(new CellRangeAddress(i, i, 3, 4));
        }
        sheet.addMergedRegion(new CellRangeAddress(i + 1, i + 1, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(i + 1, i + 1, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(i + 2, i + 2, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(i + 2, i + 2, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(i + 3, i + 3, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(i + 3, i + 3, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(i + 4, i + 4, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(i + 4, i + 4, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(i + 5, i + 5, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(i + 5, i + 5, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(i + 6, i + 6, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(i + 6, i + 6, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(i + 7, i + 7, 0, 2));
        sheet.addMergedRegion(new CellRangeAddress(i + 7, i + 7, 3, 4));
    }

    private void fillExcelData(Sheet sheet, SubComAutoDetailVo vo, Map<String, SubComFixedPayDetailVo> fixedPayDetailVoMap, CellStyle cellStyle) {
        Row rowR;
        if (Objects.isNull(sheet) || Objects.isNull(vo)) {
            return;
        }
        Row row0 = sheet.createRow(0);
        row0.createCell(0).setCellValue("\u7c7b\u578b");
        row0.createCell(3).setCellValue("\u8d39\u7528\u91d1\u989d");
        Row row1 = sheet.createRow(1);
        row1.createCell(0).setCellValue("\u7406\u8bba\u6536\u5165");
        row1.createCell(3).setCellValue(this.amountForm(vo.getTheoryIncome()));
        row1.getCell(3).setCellStyle(cellStyle);
        Row row2 = sheet.createRow(2);
        row2.createCell(0).setCellValue("\u7406\u8bba\u6210\u672c");
        row2.createCell(3).setCellValue(this.amountForm(vo.getTheoryCost()));
        row2.getCell(3).setCellStyle(cellStyle);
        Row row3 = sheet.createRow(3);
        row3.createCell(0).setCellValue("\u7406\u8bba\u6bdb\u5229");
        row3.createCell(3).setCellValue(this.amountForm(vo.getTheoryProfit()));
        row3.getCell(3).setCellStyle(cellStyle);
        int i = 4;
        if (!CollectionUtils.isEmpty(fixedPayDetailVoMap)) {
            rowR = sheet.createRow(i);
            rowR.createCell(0).setCellValue("\u56fa\u5b9a\u652f\u51fa");
            Set<String> keySet = fixedPayDetailVoMap.keySet();
            ArrayList<String> keyList = new ArrayList<String>(keySet);
            for (int a = 0; a < keySet.size(); ++a) {
                if (a == 0) {
                    rowR.createCell(1).setCellValue(fixedPayDetailVoMap.get(keyList.get(a)).getBudgetItemName());
                    rowR.createCell(3).setCellValue(this.amountForm(fixedPayDetailVoMap.get(keyList.get(a)).getFeeAmount()));
                    rowR.getCell(3).setCellStyle(cellStyle);
                    continue;
                }
                Row row = sheet.createRow(i + a);
                row.createCell(1).setCellValue(fixedPayDetailVoMap.get(keyList.get(a)).getBudgetItemName());
                row.createCell(3).setCellValue(this.amountForm(fixedPayDetailVoMap.get(keyList.get(a)).getFeeAmount()));
                row.getCell(3).setCellStyle(cellStyle);
            }
            i = i + keySet.size() - 1;
        } else {
            rowR = sheet.createRow(i);
            rowR.createCell(0).setCellValue("\u56fa\u5b9a\u652f\u51fa");
            rowR.createCell(3).setCellValue(0.0);
            rowR.getCell(3).setCellStyle(cellStyle);
        }
        Row row_7 = sheet.createRow(i + 1);
        row_7.createCell(0).setCellValue("\u56fa\u5b9a\u652f\u51fa\u5c0f\u8ba1");
        row_7.createCell(3).setCellValue(this.amountForm(vo.getFixedPayTotal()));
        row_7.getCell(3).setCellStyle(cellStyle);
        Row row_6 = sheet.createRow(i + 2);
        row_6.createCell(0).setCellValue("\u5229\u6da6\u76ee\u6807");
        row_6.createCell(3).setCellValue(this.amountForm(vo.getProfitGoal()));
        row_6.getCell(3).setCellStyle(cellStyle);
        Row row_5 = sheet.createRow(i + 3);
        row_5.createCell(0).setCellValue("\u8003\u6838\u6263\u6b3e");
        row_5.createCell(3).setCellValue(this.amountForm(vo.getAssessDeduction()));
        row_5.getCell(3).setCellStyle(cellStyle);
        Row row_4 = sheet.createRow(i + 4);
        row_4.createCell(0).setCellValue("\u7a0e\u91d1\u53ca\u9644\u52a0");
        row_4.createCell(3).setCellValue(this.amountForm(vo.getTaxAmount()));
        row_4.getCell(3).setCellStyle(cellStyle);
        Row row_3 = sheet.createRow(i + 5);
        row_3.createCell(0).setCellValue("\u81ea\u6295\u8d39\u7528");
        row_3.createCell(3).setCellValue(this.amountForm(vo.getAutoAmount()));
        row_3.getCell(3).setCellStyle(cellStyle);
        Row row_2 = sheet.createRow(i + 6);
        row_2.createCell(0).setCellValue("\u6838\u51c6\u91d1\u989d");
        row_2.createCell(3).setCellValue(this.amountForm(vo.getApprovedAmount()));
        row_2.getCell(3).setCellStyle(cellStyle);
        Row row_1 = sheet.createRow(i + 7);
        row_1.createCell(0).setCellValue("\u6838\u51c6\u5907\u6ce8");
        row_1.createCell(3).setCellValue(vo.getRemark());
        Row rowT1 = sheet.createRow(i + 12);
        rowT1.createCell(1).setCellValue("\u5e74\u5ea6");
        rowT1.createCell(2).setCellValue("\u6708\u5ea6");
        rowT1.createCell(3).setCellValue("\u6708\u5ea6vs\u5e74\u5ea6");
        Row rowT2 = sheet.createRow(i + 13);
        rowT2.createCell(0).setCellValue("\u6298\u524d\u9500\u552e\u989d");
        rowT2.createCell(1).setCellValue(this.amountForm(vo.getYearBeforeDiscountSales()));
        rowT2.createCell(2).setCellValue(this.amountForm(vo.getMonthBeforeDiscountSales()));
        rowT2.createCell(3).setCellValue(this.amountForm(vo.getDiffBeforeDiscountSales()));
        rowT2.getCell(1).setCellStyle(cellStyle);
        rowT2.getCell(2).setCellStyle(cellStyle);
        rowT2.getCell(3).setCellStyle(cellStyle);
        Row rowT3 = sheet.createRow(i + 14);
        rowT3.createCell(0).setCellValue("\u6298\u540e\u9500\u552e\u989d");
        rowT3.createCell(1).setCellValue(this.amountForm(vo.getYearAfterDiscountSales()));
        rowT3.createCell(2).setCellValue(this.amountForm(vo.getMonthAfterDiscountSales()));
        rowT3.createCell(3).setCellValue(this.amountForm(vo.getDiffAfterDiscountSales()));
        rowT3.getCell(1).setCellStyle(cellStyle);
        rowT3.getCell(2).setCellStyle(cellStyle);
        rowT3.getCell(3).setCellStyle(cellStyle);
        Row rowT4 = sheet.createRow(i + 15);
        rowT4.createCell(0).setCellValue("\u81ea\u6295\u91d1\u989d");
        rowT4.createCell(1).setCellValue(this.amountForm(vo.getYearAutoAmount()));
        rowT4.createCell(2).setCellValue(this.amountForm(vo.getAutoAmount()));
        rowT4.createCell(3).setCellValue(this.amountForm(vo.getDiffAutoAmount()));
        rowT4.getCell(1).setCellStyle(cellStyle);
        rowT4.getCell(2).setCellStyle(cellStyle);
        rowT4.getCell(3).setCellStyle(cellStyle);
        Row rowT5 = sheet.createRow(i + 16);
        rowT5.createCell(0).setCellValue("\u6298\u524d\u8d39\u9500\u6bd4");
        rowT5.createCell(1).setCellValue(this.amountForm(vo.getYearBeforeDiscountRatio()));
        rowT5.createCell(2).setCellValue(this.amountForm(vo.getMonthBeforeDiscountRatio()));
        rowT5.createCell(3).setCellValue(this.amountForm(vo.getDiffBeforeDiscountRatio()));
        rowT5.getCell(1).setCellStyle(cellStyle);
        rowT5.getCell(2).setCellStyle(cellStyle);
        rowT5.getCell(3).setCellStyle(cellStyle);
        Row rowT6 = sheet.createRow(i + 17);
        rowT6.createCell(0).setCellValue("\u6298\u540e\u8d39\u9500\u6bd4");
        rowT6.createCell(1).setCellValue(this.amountForm(vo.getYearAfterDiscountRatio()));
        rowT6.createCell(2).setCellValue(this.amountForm(vo.getMonthAfterDiscountRatio()));
        rowT6.createCell(3).setCellValue(this.amountForm(vo.getDiffAfterDiscountRatio()));
        rowT6.getCell(1).setCellStyle(cellStyle);
        rowT6.getCell(2).setCellStyle(cellStyle);
        rowT6.getCell(3).setCellStyle(cellStyle);
    }

    private double amountForm(BigDecimal amount) {
        if (Objects.isNull(amount)) {
            return 0.0;
        }
        return amount.doubleValue();
    }
}

