/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastEntity;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastDetailRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastRepository;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComBudgetForecastDetailService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastCallBackService;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubComBudgetForecastCallBackServiceImpl
implements SubComBudgetForecastCallBackService {
    private static final Logger log = LoggerFactory.getLogger(SubComBudgetForecastCallBackServiceImpl.class);
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private SubComBudgetForecastDetailRepository subComBudgetForecastDetailRepository;
    @Resource
    private SubComBudgetForecastRepository subComBudgetForecastRepository;
    @Resource
    private SubComBudgetForecastDetailService subComBudgetForecastDetailService;

    @Transactional(rollbackFor={Exception.class})
    public void adjustPass(ProcessStatusDto dto) {
        log.info("\u8fdb\u5165\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u8c03\u6574\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\uff0c\u6d41\u7a0b\u7f16\u53f7:{},\u6d41\u7a0b\u72b6\u6001:{}", (Object)dto.getProcessNo(), (Object)dto.getProcessStatus());
        Validate.notNull((Object)dto, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessNo(), (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComBudgetForecastDetailEntity> detailEntityList = this.subComBudgetForecastDetailRepository.listByProcessNo(dto.getProcessNo());
        Validate.notEmpty(detailEntityList, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u5bf9\u5e94\u9884\u7b97\u9884\u6d4b\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        detailEntityList.forEach(detailEntity -> {
            detailEntity.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            SubComBudgetForecastEntity budgetForecastEntity = this.subComBudgetForecastRepository.getByCode(detailEntity.getBudgetForecastCode());
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(detailEntity.getOperationType())) {
                detailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                budgetForecastEntity.setAdjustAmount(Optional.ofNullable(budgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setApprovingAmount(Optional.ofNullable(budgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(detailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setAfterFreezeAmount(Optional.ofNullable(budgetForecastEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setRemainderAmount(Optional.ofNullable(budgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                detailEntity.setBeforeAmount(Optional.ofNullable(budgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(detailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                detailEntity.setBalanceAmount(budgetForecastEntity.getRemainderAmount());
            }
            if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(detailEntity.getOperationType())) {
                budgetForecastEntity.setApprovingAmount(Optional.ofNullable(budgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
            }
            this.subComBudgetForecastRepository.updateById((Object)budgetForecastEntity);
        });
        this.subComBudgetForecastDetailRepository.updateBatchById(detailEntityList);
    }

    public void adjustRejectAndRecover(ProcessStatusDto dto) {
        log.info("\u8fdb\u5165\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u8c03\u6574\u5ba1\u6279\u9a73\u56de\u56de\u8c03\uff0c\u6d41\u7a0b\u7f16\u53f7:{},\u6d41\u7a0b\u72b6\u6001:{}", (Object)dto.getProcessNo(), (Object)dto.getProcessStatus());
        Validate.notNull((Object)dto, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessNo(), (String)"\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComBudgetForecastDetailEntity> monthBudgetDetailEntityList = this.subComBudgetForecastDetailRepository.listByProcessNo(dto.getProcessNo());
        Validate.notEmpty(monthBudgetDetailEntityList, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u5bf9\u5e94\u9884\u7b97\u9884\u6d4b\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        monthBudgetDetailEntityList.forEach(budgetForecastDetailEntity -> {
            budgetForecastDetailEntity.setProcessStatus(dto.getProcessStatus());
            SubComBudgetForecastEntity budgetForecastEntity = this.subComBudgetForecastRepository.getByCode(budgetForecastDetailEntity.getBudgetForecastCode());
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(budgetForecastDetailEntity.getOperationType())) {
                budgetForecastEntity.setApprovingAmount(Optional.ofNullable(budgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastDetailEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            }
            if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(budgetForecastDetailEntity.getOperationType())) {
                budgetForecastEntity.setAdjustAmount(Optional.ofNullable(budgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setApprovingAmount(Optional.ofNullable(budgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setAfterFreezeAmount(Optional.ofNullable(budgetForecastEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setRemainderAmount(Optional.ofNullable(budgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
            }
            this.subComBudgetForecastRepository.updateById((Object)budgetForecastEntity);
            if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(budgetForecastDetailEntity.getOperationType())) {
                SubComBudgetForecastDetailDto budgetForecastDetailDto = this.buildDetail(budgetForecastEntity, budgetForecastDetailEntity.getCurOperationAmount(), BudgetOperationTypeEnum.RELEASE.getCode());
                this.subComBudgetForecastDetailService.create(budgetForecastDetailDto);
            }
        });
        this.subComBudgetForecastDetailRepository.updateBatchById(monthBudgetDetailEntityList);
    }

    public void changePass(ProcessStatusDto dto) {
        log.info("\u8fdb\u5165\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\uff0c\u6d41\u7a0b\u7f16\u53f7:{},\u6d41\u7a0b\u72b6\u6001:{}", (Object)dto.getProcessNo(), (Object)dto.getProcessStatus());
        Validate.notNull((Object)dto, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessNo(), (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComBudgetForecastDetailEntity> budgetForecastDetailEntityList = this.subComBudgetForecastDetailRepository.listByProcessNo(dto.getProcessNo());
        Validate.notEmpty(budgetForecastDetailEntityList, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u5bf9\u5e94\u9884\u7b97\u9884\u6d4b\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        budgetForecastDetailEntityList.forEach(budgetForecastDetailEntity -> {
            budgetForecastDetailEntity.setProcessStatus(dto.getProcessStatus());
            SubComBudgetForecastEntity budgetForecastEntity = this.subComBudgetForecastRepository.getByCode(budgetForecastDetailEntity.getBudgetForecastCode());
            if (BudgetOperationTypeEnum.ADD.getCode().equals(budgetForecastDetailEntity.getOperationType())) {
                budgetForecastDetailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                budgetForecastEntity.setAdjustAmount(Optional.ofNullable(budgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setApprovingAmount(Optional.ofNullable(budgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setAfterFreezeAmount(Optional.ofNullable(budgetForecastEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setRemainderAmount(Optional.ofNullable(budgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastDetailEntity.setBeforeAmount(Optional.ofNullable(budgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastDetailEntity.setBalanceAmount(budgetForecastEntity.getRemainderAmount());
            }
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(budgetForecastDetailEntity.getOperationType())) {
                budgetForecastEntity.setApprovingAmount(Optional.ofNullable(budgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
            }
            this.subComBudgetForecastRepository.updateById((Object)budgetForecastEntity);
        });
        this.subComBudgetForecastDetailRepository.updateBatchById(budgetForecastDetailEntityList);
    }

    public void changeRejectAndRecover(ProcessStatusDto dto) {
        log.info("\u8fdb\u5165\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u53d8\u66f4\u5ba1\u6279\u9a73\u56de\u56de\u8c03\uff0c\u6d41\u7a0b\u7f16\u53f7:{},\u6d41\u7a0b\u72b6\u6001:{}", (Object)dto.getProcessNo(), (Object)dto.getProcessStatus());
        Validate.notNull((Object)dto, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessNo(), (String)"\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComBudgetForecastDetailEntity> budgetForecastDetailEntityList = this.subComBudgetForecastDetailRepository.listByProcessNo(dto.getProcessNo());
        Validate.notEmpty(budgetForecastDetailEntityList, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u5bf9\u5e94\u9884\u7b97\u9884\u6d4b\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        budgetForecastDetailEntityList.forEach(budgetForecastDetailEntity -> {
            budgetForecastDetailEntity.setProcessStatus(dto.getProcessStatus());
            SubComBudgetForecastEntity budgetForecastEntity = this.subComBudgetForecastRepository.getByCode(budgetForecastDetailEntity.getBudgetForecastCode());
            if (BudgetOperationTypeEnum.ADD.getCode().equals(budgetForecastDetailEntity.getOperationType())) {
                budgetForecastEntity.setApprovingAmount(Optional.ofNullable(budgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastDetailEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            }
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(budgetForecastDetailEntity.getOperationType())) {
                budgetForecastEntity.setAdjustAmount(Optional.ofNullable(budgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setApprovingAmount(Optional.ofNullable(budgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setAfterFreezeAmount(Optional.ofNullable(budgetForecastEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                budgetForecastEntity.setRemainderAmount(Optional.ofNullable(budgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetForecastDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
            }
            this.subComBudgetForecastRepository.updateById((Object)budgetForecastEntity);
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(budgetForecastDetailEntity.getOperationType())) {
                SubComBudgetForecastDetailDto budgetForecastDetailDto = this.buildDetail(budgetForecastEntity, budgetForecastDetailEntity.getCurOperationAmount(), BudgetOperationTypeEnum.RELEASE.getCode());
                this.subComBudgetForecastDetailService.create(budgetForecastDetailDto);
            }
        });
        this.subComBudgetForecastDetailRepository.updateBatchById(budgetForecastDetailEntityList);
    }

    public void manualPass(ProcessStatusDto dto) {
        log.info("\u8fdb\u5165\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u624b\u52a8\u5f55\u5165\u6570\u636e\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\uff0c\u6d41\u7a0b\u7f16\u53f7:{},\u6d41\u7a0b\u72b6\u6001:{}", (Object)dto.getProcessNo(), (Object)dto.getProcessStatus());
        Validate.notNull((Object)dto, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessNo(), (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SubComBudgetForecastEntity budgetForecastEntity = this.subComBudgetForecastRepository.getByProcessNo(dto.getProcessNo());
        Validate.notNull((Object)((Object)budgetForecastEntity), (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u6839\u636e\u6d41\u7a0b\u7f16\u7801\u672a\u67e5\u5230\u9884\u7b97\u9884\u6d4b\u6570\u636e\uff01", (Object[])new Object[0]);
        budgetForecastEntity.setProcessStatus(dto.getProcessStatus());
        budgetForecastEntity.setProcessTime(new Date());
        if ("manual".equals(budgetForecastEntity.getDataSourceCode())) {
            budgetForecastEntity.setFirstBudgetAmount(Optional.ofNullable(budgetForecastEntity.getBudgetAmount()).orElse(BigDecimal.ZERO));
            budgetForecastEntity.setUsedAmount(BigDecimal.ZERO);
            budgetForecastEntity.setAdjustAmount(BigDecimal.ZERO);
            budgetForecastEntity.setFreezeAmount(BigDecimal.ZERO);
            budgetForecastEntity.setRemainderAmount(budgetForecastEntity.getFirstBudgetAmount());
        }
        this.subComBudgetForecastRepository.updateById((Object)budgetForecastEntity);
    }

    public void manualRejectAndRecover(ProcessStatusDto dto) {
        log.info("\u8fdb\u5165\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u624b\u52a8\u5f55\u5165\u6570\u636e\u5ba1\u6279\u5ba1\u6279\u9a73\u56de\u3001\u8ffd\u56de\u56de\u8c03\uff0c\u6d41\u7a0b\u7f16\u53f7:{},\u6d41\u7a0b\u72b6\u6001:{}", (Object)dto.getProcessNo(), (Object)dto.getProcessStatus());
        Validate.notNull((Object)dto, (String)"\u5ba1\u6279\u5ba1\u6279\u9a73\u56de\u3001\u8ffd\u56de\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessNo(), (String)"\u5ba1\u6279\u5ba1\u6279\u9a73\u56de\u3001\u8ffd\u56de\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SubComBudgetForecastEntity budgetForecastEntity = this.subComBudgetForecastRepository.getByProcessNo(dto.getProcessNo());
        Validate.notNull((Object)((Object)budgetForecastEntity), (String)"\u5ba1\u6279\u5ba1\u6279\u9a73\u56de\u3001\u8ffd\u56de\u56de\u8c03\u5931\u8d25\uff0c\u6839\u636e\u6d41\u7a0b\u7f16\u7801\u672a\u67e5\u5230\u9884\u7b97\u9884\u6d4b\u6570\u636e\uff01", (Object[])new Object[0]);
        budgetForecastEntity.setProcessStatus(dto.getProcessStatus());
        budgetForecastEntity.setProcessTime(new Date());
        this.subComBudgetForecastRepository.updateById((Object)budgetForecastEntity);
    }

    private SubComBudgetForecastDetailDto buildDetail(SubComBudgetForecastEntity subComBudgetForecastEntity, BigDecimal operationAmount, String operationType) {
        SubComBudgetForecastDetailDto budgetDetailDto = (SubComBudgetForecastDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        budgetDetailDto.setId(null);
        budgetDetailDto.setOperationType(operationType);
        budgetDetailDto.setInitialAmount(subComBudgetForecastEntity.getFirstBudgetAmount());
        if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType) || BudgetOperationTypeEnum.RETURN.getCode().equals(operationType) || BudgetOperationTypeEnum.REPLAY.getCode().equals(operationType) || BudgetOperationTypeEnum.ACTUAL_SALES.getCode().equals(operationType)) {
            budgetDetailDto.setBeforeAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType) || BudgetOperationTypeEnum.SUBTRACT.getCode().equals(operationType) || BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType) || BudgetOperationTypeEnum.USE.getCode().equals(operationType) || BudgetOperationTypeEnum.FORECAST_OVER.getCode().equals(operationType)) {
            budgetDetailDto.setBeforeAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
        }
        budgetDetailDto.setCurOperationAmount(operationAmount);
        budgetDetailDto.setBalanceAmount(subComBudgetForecastEntity.getRemainderAmount());
        return budgetDetailDto;
    }
}

